// ***************************************************************************
// X-Wing Miniatures AI 2nd Edition - Javascript
// Version: 2.2.3
//Adds BTA-NR2 Y-Wing (Inadvertantly left out of last major update)
// ****************************************************************************
// Constants

// ENEMY SHIP DIRECTIONS
var DIR_000 = 0;   //Outside Bullseye, 010-044
var DIR_045 = 1;   //045-089
var DIR_090 = 2;   //090-134
var DIR_135 = 3;   //135-179
var DIR_180 = 4;   //180-224
var DIR_225 = 5;   //225-269
var DIR_270 = 6;   //270-314
var DIR_315 = 7;   //Outside Bullseye, 315-349
var DIR_360 = 8;   //Bullseye, 350-010
var DIR_ship = 9;  //Ship image sector, for reroll blinking

var DIRECTION = [ "1-2", "2-3", "3-4", "4-6", "6-8", "8-9", "9-10", "10-11", "Bullseye" ];

//Click timing for single vs double clicks
var pendingClick;
var clicked = 0;
var time_dblclick = 300; // 300 ms

//Load or initialize Hotlist
//Each time a page changes, xwing_ai2.js reloads. User HOTLIST selections are stored in a sessionStorage key in the user's web browser
//so that on a page reload, the user's HOTLIST can be restored on the new page.
//The storage key remains in place until the user leaves the browser tab running x-wing-ai.com or quits the browser

var HOTLIST = [ "NONE" ]; //This is the variable array that contains the users Hotlist ships
if (sessionStorage.getItem("2EuserHotlist"))
	{
		HOTLIST = JSON.parse(sessionStorage.getItem("2EuserHotlist"));
	}

//Longpress timer
var longPress = 500; //in milliseconds

// HEADING
var AWAY = "R2 Opening/R3";            // Heading away
var CLOSING = "R1/R2 Closing";            // Closing
var FAR = "R4+";           			// Far
var STRESSED = "Stressed";          // Stressed

//Image Map
var image_map = "";

//Planning PHASE (New for 2.5.1 Update)
var planning = "";

// ACTIONS

var actions = "";
var moveicon = "";


// These variables are new for 2.5.1 Update
var cloakTest;
var lockText = "";
var evadeTest;
var focusTest;
var labelTest;
var reloadTest;
var rotateTest;
var reinforceTest;


//STATS (New for 2.2.0 Update)
var stats = "";

//SYSTEM ( and Post-System) PHASE (New for 2.2.2 Update)
var system = "";
var DECLOAK_SMALL = [ "2L", "2R", "2F" ];
var DECLOAK_MED_LG = [ "1L", "1R", "1F" ];
var DECLOAK_DIEROLL = [ "B", "F", "H", "H", "B", "F", "H", "C" ];
var deviceType = 0;
var Type = 0;
var ATTACKDIE = [ "B", "B", "F", "F", "H", "H", "H", "C" ];
var postsystem = "";
var dName = "";
var deviceName = "";

//TARGETS (New for 2.5.1 Update)
var targets = "";

//SPECIAL MANEUVERS (New for 2.2.0 Update)
var fullthrottle = "";
var preMove = "";
var noStress = 'AI ships do NOT gain a <img src="img/Stress_small.png" alt="Stress" title="Stress"> token as a result of conducting a <span style="color:red">"Difficult" (Red)</span> maneuver.' + "<br>";
noStress += 'However, they may <b>not</b> take an action in the Action portion of the Activation Phase if they conducted a <span style="color:red">"Difficult" (Red)</span> maneuver.'

// ACTIONS TEXT
var BARREL_ROLL_TEXT1 = '<img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> to avoid Target\'s arc'; //"AVOID"
var BARREL_ROLL_TEXT2 = '<img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> to get a shot';  //"SHOT"
var BARREL_ROLL_TEXT3 = '<img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> to avoid Target\'s arc and still get a shot'; //"AVOID_SHOT"

var BARREL_ROLL_D_TEXT1 = '<img src="img/action_barrelroll-red_small.png" alt="Barrel Roll (Difficult)" title="Barrel Roll (Difficult)"> to avoid Target\'s arc'; //"D_AVOID"
var BARREL_ROLL_D_TEXT2 = '<img src="img/action_barrelroll-red_small.png" alt="Barrel Roll (Difficult)" title="Barrel Roll (Difficult)"> to get a shot';  //"D_SHOT"
var BARREL_ROLL_D_TEXT3 = '<img src="img/action_barrelroll-red_small.png" alt="Barrel Roll (Difficult)" title="Barrel Roll (Difficult)"> to avoid Target\'s arc and still get a shot'; //"D_AVOID_SHOT"
var BARREL_ROLL_D_TEXT4 = '<img src="img/action_barrelroll-red_small.png" alt="Barrel Roll (Difficult)" title="Barrel Roll (Difficult)"> to get Target at Range 2 and in <img src="img/turret_arc_small.png" alt="Turret Arc" title="Turret Arc">'; //"D_M_R2"
var BARREL_ROLL_D_TEXT5 = '<img src="img/action_barrelroll-red_small.png" alt="Barrel Roll (Difficult)" title="Barrel Roll (Difficult)"> to get a shot or avoid target\'s arc.'; //AUTOTHRUSTERS

var BARREL_ROLL2CALC_D_TEXT1 = 'Choose <img src="img/action_barrelroll.png" alt="Barrel Roll" title="Barrel Roll"> if this will put target into AI ship\'s firing arc. Gain 1 <img src="img/action_calculate-red_small.png" alt="Calculate (Difficult)" title="Calculate (Difficult)"> token and one <img src="img/Stress_small.png" alt="Stress" title="Stress"> token.';
var BARREL_ROLL2CALC_D_TEXT2 = 'Choose <img src="img/action_barrelroll.png" alt="Barrel Roll" title="Barrel Roll"> if this will put the AI ship out of enemy ship firing arc. OPTIONAL: Gain 1 <img src="img/action_calculate-red_small.png" alt="Calculate (Difficult)" title="Calculate (Difficult)"> token and one <img src="img/Stress_small.png" alt="Stress" title="Stress"> token.';

var BARREL_ROLL2EVADE_D_TEXT1 = 'Choose <img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> if this will put target into AI ship\'s firing arc. If AI is in a firing arc, choose <img src="img/action_evade-red_small.png" alt="Evade (Difficult)" title="Evade (Difficult)">.';
var BARREL_ROLL2EVADE_D_TEXT2 = 'Choose <img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> if this will put the AI ship out of enemy ship firing arc. OPTIONAL: choose <img src="img/action_evade-red_small.png" alt="Evade (Difficult)" title="Evade (Difficult)">.';

var BARREL_ROLL2LOCK_D_TEXT1 = '<img src="img/action_barrelroll2lock-red_small.png" alt="Barrel Roll to Target-Lock (Difficult)" title="Barrel Roll to Target-Lock (Difficult)"> to avoid target arc and still get a shot';
var BARREL_ROLL2LOCK_D_TEXT2 = '<img src="img/action_barrelroll2lock-red_small.png" alt="Barrel Roll to Target-Lock (Difficult)" title="Barrel Roll to Target-Lock (Difficult)"> to get a shot';

var BOOST2LOCK_D_TEXT1 = '<img src="img/action_boost2lock-red_small.png" alt="Boost to Target-Lock (Difficult)" title="Boost to Target-Lock (Difficult)"> to avoid target arc and still get a shot';
var BOOST2LOCK_D_TEXT2 = '<img src="img/action_boost2lock-red_small.png" alt="Boost to Target-Lock (Difficult)" title="Boost to Target-Lock (Difficult)"> to get a shot';

var BARREL_ROLL2ROTATE_TEXT = 'OPTIONAL: If no target in AI Turret Arc, <img src="img/action_rotatearc.png" alt="Rotate Turret Arc" title="Rotate Turret Arc"> to target an enemy ship.<br>';
var BARREL_ROLL2ROTATE_D_TEXT = 'OPTIONAL: If no target in AI Turret Arc, <img src="img/action_rotatearc-red.png" alt="Rotate Turret Arc (Difficult)" title="Rotate Turret Arc (Difficult)"> to target an enemy ship.';

var BARREL_ROLL_OR_BOOST_TEXT1 = '<img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> or <img src="img/action_boost_small.png" alt="Boost" title="Boost"> to get a shot';
var BARREL_ROLL_OR_BOOST_TEXT2 = '<img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> or <img src="img/action_boost_small.png" alt="Boost" title="Boost"> to get within Range 1 and get a shot';
var BARREL_ROLL_OR_BOOST_TEXT3 = '<img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> or <img src="img/action_boost_small.png" alt="Boost" title="Boost"> to avoid Target\'s arc';
var BARREL_ROLL_OR_BOOST_TEXT4 = '<img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> or <img src="img/action_boost_small.png" alt="Boost" title="Boost"> to get a shot and\\or avoid Target\'s arc';

var BARREL_ROLL_OR_BOOST_F_TEXT1 = 'If you have a <img src="img/token_force_small.png" alt="Force Charge" title="Force Charge"> available, use Fine-Tuned Controls Ability to <img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> or <img src="img/action_boost_small.png" alt="Boost" title="Boost"> to get a shot';
var BARREL_ROLL_OR_BOOST_F_TEXT2 = 'If you have a <img src="img/token_force_small.png" alt="Force Charge" title="Force Charge"> available, use Fine-Tuned Controls Ability to <img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> or <img src="img/action_boost_small.png" alt="Boost" title="Boost"> to get within Range 1 and get a shot';
var BARREL_ROLL_OR_BOOST_F_TEXT3 = 'If you have a <img src="img/token_force_small.png" alt="Force Charge" title="Force Charge"> available, use Fine-Tuned Controls Ability to <img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> or <img src="img/action_boost_small.png" alt="Boost" title="Boost"> to avoid Target\'s arc';


var BOOST_OR_BARREL_ROLL_M_TEXT1 = '<img src="img/action_boost_small.png" alt="Boost" title="Boost"> or <img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> to get a shot';
var BOOST_OR_BARREL_ROLL_M_TEXT2 = '<img src="img/action_boost_small.png" alt="Boost" title="Boost"> or <img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> to avoid Target\'s arc';

var BOOST_OR_BARREL_ROLL2FOCUS_D_TEXT1 = '<img src="img/action_boost_small.png" alt="Boost" title="Boost"> or <img src="img/action_barrelroll2focus-red_small.png" alt="Barrel Roll to Focus (Difficult)" title="Barrel Roll to Focus (Difficult)"> to avoid Target\'s arc and still get a shot';
var BOOST_OR_BARREL_ROLL2FOCUS_D_TEXT2 = '<img src="img/action_boost_small.png" alt="Boost" title="Boost"> or <img src="img/action_barrelroll2focus-red_small.png" alt="Barrel Roll to Focus (Difficult)" title="Barrel Roll to Focus (Difficult)"> to get within Range 1 and get a shot';
var BOOST_OR_BARREL_ROLL2FOCUS_D_TEXT3 = '<img src="img/action_boost_small.png" alt="Boost" title="Boost"> or <img src="img/action_barrelroll2focus-red_small.png" alt="Barrel Roll to Focus (Difficult)" title="Barrel Roll to Focus (Difficult)"> to get a shot';

var BOOST_OR_BARREL_ROLL2FOCUS_OR_CALCULATE_D_TEXT1 = '<img src="img/action_boost_small.png" alt="Boost" title="Boost"> or <img src="img/action_barrelroll2focus-red_small.png" alt="Barrel Roll to Focus (Difficult)" title="Barrel Roll to Focus (Difficult)"> to avoid Target\'s arc and still get a shot';
var BOOST_OR_BARREL_ROLL2FOCUS_OR_CALCULATE_D_TEXT2 = '<img src="img/action_boost_small.png" alt="Boost" title="Boost"> or <img src="img/action_barrelroll2focus-red_small.png" alt="Barrel Roll to Focus (Difficult)" title="Barrel Roll to Focus (Difficult)"> to get within Range 1 and get a shot';
var BOOST_OR_BARREL_ROLL2FOCUS_OR_CALCULATE_D_TEXT3 = '<img src="img/action_boost_small.png" alt="Boost" title="Boost"> or <img src="img/action_barrelroll2focus-red_small.png" alt="Barrel Roll to Focus (Difficult)" title="Barrel Roll to Focus (Difficult)"> to get a shot';


var BOOST_TEXT1 = '<img src="img/action_boost_small.png" alt="Boost" title="Boost"> to get a shot';
var BOOST_TEXT2 = '<img src="img/action_boost_small.png" alt="Boost" title="Boost"> to get within Range 1 and still get a shot';
var BOOST_TEXT3 = '<img src="img/action_boost_small.png" alt="Boost" title="Boost"> to avoid Target\'s arc';

var BOOST_D_TEXT1 = '<img src="img/action_boost-red_small.png" alt="Boost (Difficult)" title="Boost (Difficult)"> to get a shot or avoid target\'s arc.';

var BOOST2CALC_D_TEXT1 = 'Choose <img src="img/action_boost_small.png" alt="Boost" title="Boost"> if this will put target into AI ship\'s firing arc. OPTIONAL: Gain 1 <img src="img/action_calculate-red_small.png" alt="Calculate (Difficult)" title="Calculate (Difficult)"> token and one <img src="img/Stress_small.png" alt="Stress" title="Stress"> token.';
var BOOST2CALC_D_TEXT2 = 'Choose <img src="img/action_boost_small.png" alt="Boost" title="Boost"> if this will put the AI ship out of enemy ship firing arc. OPTIONAL: Gain 1 <img src="img/action_calculate-red_small.png" alt="Calculate (Difficult)" title="Calculate (Difficult)"> token and one <img src="img/Stress_small.png" alt="Stress" title="Stress"> token.';

var BOOST2ROTATE_TEXT = 'OPTIONAL: If no target in AI Turret Arc, <img src="img/action_rotatearc.png" alt="Rotate Turret Arc" title="Rotate Turret Arc"> to target an enemy ship.<br>';

var B2BR_BR2B_D_TEXT1 = '<img src="img/action_boost2barrel_roll-red_small.png" alt="Boost to Barrel Roll (Difficult)" title="Boost to Barrel Roll (Difficult)"> or <img src="img/action_barrelroll2boost-red_small.png" alt="Barrel Roll to Boost (Difficult)" title="Barrel Roll to Boost (Difficult)"> to get a shot';
var B2BR_BR2B_D_TEXT2 = '<img src="img/action_boost2barrel_roll-red_small.png" alt="Boost to Barrel Roll (Difficult)" title="Boost to Barrel Roll (Difficult)"> or <img src="img/action_barrelroll2boost-red_small.png" alt="Barrel Roll to Boost (Difficult)" title="Barrel Roll to Boost (Difficult)"> to avoid all enemy arc\'s';

var CALCULATE_TEXT = '<img src="img/action_calculate_small.png" alt="Calculate" title="Calculate"> if there are no more advantageous actions to take. Gain 1 <img src="img/action_calculate_small.png" alt="Calculate" title="Calculate"> token.';
var CALCULATE_D_TEXT = '<img src="img/action_calculate-red_small.png" alt="Calculate (Difficult)" title=" (Difficult)"> if there are no more advantageous actions to take. Gain 1 <img src="img/action_calculate_small.png" alt="Calculate" title="Calculate"> token and one <img src="img/Stress_small.png" alt="Stress" title="Stress"> token.';
var CALCULATE_SHOT_TEXT = '<img src="img/action_calculate_small.png" alt="Calculate" title="Calculate"> if you have a shot.';

var CLOAKING_TEXT0 = '<img src="img/action_cloak_small.png" alt="Cloak" title="Cloak"> if you don\'t have a shot';
var CLOAKING_TEXT1 = 'If you have the \'Scimitar\' title, <img src="img/action_cloak-red_small.png" alt="Cloak (Difficult)" title="Cloak (Difficult)"> if you don\'t have a shot';


var COORDINATE_TEXT = '<img src="img/action_coordinate_small.png" alt="Coordinate" title="Coordinate"> nearest friendly ship';
var COORDINATE_D_TEXT = 'If not in an Enemy firing arc, <img src="img/action_coordinate-red_small.png" alt="Coordinate (Difficult)" title="(Difficult)"> nearest friendly ship';

var EVADE_TEXT0 = '<img src="img/action_evade_small.png" alt="Evade" title="Evade">';
var EVADE_TEXT1 = '<img src="img/action_evade_small.png" alt="Evade" title="Evade"> if ship is not already evading';
var EVADE_TEXT2 = '<img src="img/action_evade_small.png" alt="Evade" title="Evade">';
var EVADE_TEXT3 = '<img src="img/action_evade_small.png" alt="Evade" title="Evade"> if in an enemy\'s arc.';

var EVADE_D_TEXT = '<img src="img/action_evade-red.png" alt="Evade (Difficult)" title="Evade (Difficult)if in an enemy\'s arc.">';

var EVADE_F_TEXT0 = '<img src="img/action_evade-purple_small.png" alt="Evade" title="Evade"> if you have a <img src="img/token_force_small.png" alt="Force Charge" title="Force Charge"> available.';
var EVADE_F_TEXT1 = '<img src="img/action_evade-purple_small.png" alt="Evade" title="Evade"> if ship is not already evading and if you have a <img src="img/token_force_small.png" alt="Force Charge" title="Force Charge"> available.';
var EVADE_F_TEXT2 = '<img src="img/action_evade-purple_small.png" alt="Evade" title="Evade">if you have a <img src="img/token_force_small.png" alt="Force Charge" title="Force Charge"> available.';

var EVADE2BARREL_ROLL_D_TEXT1 = 'If AI ship is in an enemy firing arc, choose <img src="img/action_evade_small.png" alt="Evade" title="Evade"> then <img src="img/action_barrelroll-red_small.png" alt="Barrel Roll (Difficult)" title="Barrel Roll (Difficult)"> if this will put target into AI ship\'s firing arc.';
var EVADE2BARREL_ROLL_D_TEXT2 = 'If AI ship is in an enemy firing arc, choose <img src="img/action_evade_small.png" alt="Evade" title="Evade"> then <img src="img/action_barrelroll-red_small.png" alt="Barrel Roll (Difficult)" title="Barrel Roll (Difficult)"> if this will put the AI ship out of enemy ship firing arc.';

var EVADE2ROTATE_TEXT = 'If AI ship is in an enemy firing arc, choose <img src="img/action_evade.png" alt="Evade" title="Evade">, then, if no target in AI Turret Arc, <img src="img/action_rotatearc.png" alt="Rotate Turret Arc" title="Rotate Turret Arc"> to target an enemy ship.';
var EVADE2ROTATE_D_TEXT = 'If AI ship is in an enemy firing arc, choose <img src="img/action_evade.png" alt="Evade" title="Evade"> then, if no target in AI Turret Arc, <img src="img/action_rotatearc-red.png" alt="Rotate Turret Arc (Difficult)" title="Rotate Turret Arc (Difficult)"> to target an enemy ship.';

var FOCUS_TEXT1 = '<img src="img/action_focus_small.png" alt="Focus" title="Focus">';
var FOCUS_TEXT2 = '<img src="img/action_focus_small.png" alt="Focus" title="Focus"> if you have a shot';
var FOCUS_TEXT3 = 'Use FINE-TUNED THRUSTERS Ability if you can <img src="img/action_barrelroll_small.png" alt="Barrel Roll" title="Barrel Roll"> to get a shot and\\or get out of an enemy\'s arc.';
var FOCUS_TEXT4 = '<img src="img/action_focus_small.png" alt="Focus" title="Focus"> if in enemy arc';

var FOCUS2BARREL_ROLL_D_M_TEXT1 = '<img src="img/action_focus2barrel_roll-red_small.png" alt="Focus to Barrel Roll (Difficult)" title="Focus to Barrel Roll (Difficult)"> to avoid Target arc and still get a shot';
var FOCUS2BARREL_ROLL_D_M_TEXT2 = '<img src="img/action_focus2barrel_roll-red_small.png" alt="Focus to Barrel Roll (Difficult)" title="Focus to Barrel Roll (Difficult)"> to get a shot';

var FOCUS2BOOST_D_M_TEXT1 = '<img src="img/tgt_movement-green_small_rebel.png" alt="Only if Target has already moved" title="Only if Target has already moved"> <img src="img/action_focus2boost-red_small.png" alt="Focus to Boost (Difficult)" title="Focus to Boost (Difficult)"> to get within Range 1 and still get a shot';

var F2B_F2BR_D_TEXT1 = '<img src="img/action_focus2boost-red_small.png" alt="Focus to Boost (Difficult)" title="Focus to Boost (Difficult)"> or <img src="img/action_focus2barrel_roll-red_small.png" alt="Focus to Barrel Roll (Difficult)" title="Focus to Barrel Roll (Difficult)"> to avoid Target\'s arc and still get a shot at any enemy';
var F2B_F2BR_D_TEXT2 = '<img src="img/action_focus2barrel_roll-red_small.png" alt="Focus to Barrel Roll (Difficult)" title="Focus to Barrel Roll (Difficult)"> or <img src="img/action_focus2boost-red_small.png" alt="Focus to Boost (Difficult)" title="Focus to Boost (Difficult)"> to get a shot';

var FOC2B_FOC2BR_D_TEXT1 = '<img src="img/action_foc2b-red_small.png" alt="Focus or Calculate to Boost (Difficult)" title="Focus or Calculate to Boost (Difficult)"> or <img src="img/action_foc2br-red_small.png" alt="Focus or Calculate to Barrel Roll (Difficult)" title="Focus or Calculate to Barrel Roll (Difficult)"> to avoid Target\'s arc and still get a shot';
var FOC2B_FOC2BR_D_TEXT2 = '<img src="img/action_foc2b-red_small.png" alt="Focus or Calculate to Boost (Difficult)" title="Focus or Calculate to Boost (Difficult)"> or <img src="img/action_foc2br-red_small.png" alt="Focus or Calculate to Barrel Roll (Difficult)" title="Focus or Calculate to Barrel Roll (Difficult)"> to get a shot';

var FOCUS_OR_CALCULATE_TEXT = '<img src="img/action_focus_small.png" alt="Focus" title="Focus"> (if Human Pilot) or <img src="img/action_calculate_small.png" alt="Calculate" title="Calculate"> (if Droid Pilot)';
var FOCUS_OR_CALCULATE_SHOT_TEXT = '<img src="img/action_focus_small.png" alt="Focus" title="Focus"> (if Human Pilot) or <img src="img/action_calculate_small.png" alt="Calculate" title="Calculate"> (if Droid Pilot) if you have a shot';

var FOCUS2ROTATE_TEXT = 'If target is not in AI Turret Arc choose <img src="img/action_focus_small.png" alt="Focus" title="Focus"> then <img src="img/action_rotatearc_small.png" alt="Rotate Turret Arc" title="Rotate Turret Arc"> to target enemy ship.';
var FOCUS2ROTATE_D_TEXT = 'If target is not in AI Turret Arc but is in range for a shot, choose <img src="img/action_focus_small.png" alt="Focus" title="Focus"> then <img src="img/action_rotatearc-red_small.png" alt="Rotate Turret Arc (Difficult)" title="Rotate Turret Arc (Difficult)"> to target enemy ship.';

var JAM_TEXT = '<img src="img/action_jam.png" alt="Jam" title="Jam"> nearest Enemy ship at range 0-1 or range 2 in bullseye.';
var JAM_D_TEXT = '<img src="img/action_jam-red_small.png" alt="Jam (Difficult)" title="Jam (Difficult)"> against Target';

var LOCK2ROTATE_TEXT = 'Take a free <img src="img/action_targetlock_small.png" alt="Target-Lock" title="Target Lock">. If locked ship is outside your <img src="img/turret_arc_small.png" alt="Turret Arc" title="Turret Arc"> but in range for a shot, <img src="img/action_rotatearc_small.png" alt="Rotate Turret Arc" title="Rotate Turret Arc"> to target the locked enemy ship.';
var LOCK2ROTATE_D_TEXT = 'Take a free <img src="img/action_targetlock_small.png" alt="Target-Lock" title="Target Lock">. If locked ship is outside your <img src="img/turret_arc_small.png" alt="Turret Arc" title="Turret Arc"> but in range for a shot, <img src="img/action_rotatearc-red.png" alt="Rotate Turret Arc (Difficult)" title="Rotate Turret Arc (Difficult)"> to target the locked enemy ship.';

var RELOAD_D_TEXT1 = '<img src="img/action_reload-red_small.png" alt="Reload (Difficult)" title="Reload (Difficult)"> if no charges or equipped <img src="img/token_missile_small.png" alt="Missile" title="Missile"> or <img src="img/token_torpedo_small.png" alt="Torpedo" title="Torpedo">';
var RELOAD_D_TEXT2 = '<img src="img/action_reload-red_small.png" alt="Reload (Difficult)" title="Reload (Difficult)"> if out of <img src="img/charge.png" alt="Charges" title="Charges"> on equipped <img src="img/token_torpedo_small.png" alt="Torpedo" title="Torpedo">';

var REINFORCE_TEXT0 = '<img src="img/action_reinforce_small.png" alt="Reinforce" title="Reinforce"> (priority: <img src="img/reinforce_front_small.png" alt="Reinforce Front" title="Reinforce Front"> <img src="img/reinforce_rear_small.png" alt="Reinforce Rear" title="Reinforce Rear"> ) if within arc of 2 or more Enemies in that full arc';
var REINFORCE_TEXT1 = '<img src="img/action_reinforce_small.png" alt="Reinforce" title="Reinforce"> toward Target unless target is outside of Range 3.';
var REINFORCE_TEXT2 = '<img src="img/action_reinforce_small.png" alt="Reinforce" title="Reinforce"> (priority: <img src="img/reinforce_front_small.png" alt="Reinforce Front" title="Reinforce Front"> <img src="img/reinforce_rear_small.png" alt="Reinforce Rear" title="Reinforce Rear"> ) if within arc of 2 or more Enemies in that full arc or if within arc of 1 enemy at range 0-2.';

var REINFORCE_D_TEXT0 = '<img src="img/action_reinforce-red_small.png" alt="Reinforce (Difficult)" title="Reinforce (Difficult)"> (priority: <img src="img/reinforce_front-red_small.png" alt="Reinforce Front (Difficult)" title="Reinforce Front (Difficult)"> <img src="img/reinforce_rear-red_small.png" alt="Reinforce Rear (Difficult)" title="Reinforce Rear (Difficult)"> ) if within arc of 2 or more Enemies in that full arc';
var REINFORCE_D_TEXT1 = '<img src="img/action_reinforce-red_small.png" alt="Reinforce (Difficult)" title="Reinforce (Difficult)"> toward Target';
var REINFORCE_D_TEXT2 = '<img src="img/action_reinforce-red_small.png" alt="Reinforce (Difficult)" title="Reinforce (Difficult)"> (priority: <img src="img/reinforce_front_small.png" alt="Reinforce Front" title="Reinforce Front"> <img src="img/reinforce_rear_small.png" alt="Reinforce Rear" title="Reinforce Rear"> ) if within arc of 2 or more Enemies in that full arc or if within arc of 1 enemy at range 0-2.';

var RELOAD_TEXT = '<img src="img/action_reload_small.png" alt="Reload" title="Reload"> to recover 1 <img src="img/token_charge_small.png" alt="Charge token" title="Charge token"> on a <img src="img/token_torpedo_small.png" alt="Torpedo" title="Torpedo">, <img src="img/token_missile_small.png" alt="Missile" title="Missile"> or <img src="img/token_mine_small.png" alt="Mine/Bomb" title="Mine/Bomb"> upgrade.';
var RELOAD_D_TEXT = '<img src="img/action_reload-red_small.png" alt="Reload (Difficult)" title="Reload (Difficult)"> to recover 1 <img src="img/token_charge_small.png" alt="Charge token" title="Charge token"> on a <img src="img/token_torpedo_small.png" alt="Torpedo" title="Torpedo">, <img src="img/token_missile_small.png" alt="Missile" title="Missile"> or <img src="img/token_mine_small.png" alt="Mine/Bomb" title="Mine/Bomb"> upgrade.';
var RELOAD2CALC_D_TEXT = 'Choose <img src="img/action_reload_small.png" alt="Reload" title="Reload"> to recover 1 <img src="img/token_charge_small.png" alt="Charge token" title="Charge token"> on a <img src="img/token_torpedo_small.png" alt="Torpedo" title="Torpedo">, <img src="img/token_missile_small.png" alt="Missile" title="Missile"> or <img src="img/token_mine_small.png" alt="Mine/Bomb" title="Mine/Bomb"> upgrade. OPTIONAL: Gain 1 <img src="img/action_calculate-red.png" alt="Calculate (Difficult)" title="Calculate (Difficult)"> token.';

var RELOAD2EVADE_D_TEXT1 = '<img src="img/action_reload_small.png" alt="Reload" title="Reload"> to recover 1 <img src="img/token_charge_small.png" alt="Charge token" title="Charge token"> on a <img src="img/token_torpedo_small.png" alt="Torpedo" title="Torpedo">, <img src="img/token_missile_small.png" alt="Missile" title="Missile"> or <img src="img/token_mine_small.png" alt="Mine" title="Mine"> upgrade.';
var RELOAD2EVADE_D_TEXT2 = 'Choose <img src="img/action_reload_small.png" alt="Reload" title="Reload"> then <img src="img/action_evade-red_small.png" alt="Evade (Difficult)" title="Evade (Difficult)"> if the AI ship is in an enemy ship firing arc.';

var ROTATE_ARC_TEXT1 = '<img src="img/action_rotatearc_small.png" alt="Rotate Turret Arc" title="Rotate Turret Arc"> to get a shot if Target is neither in your <img src="img/in_arc.png" alt="Forward Arc" title="Forward Arc"> nor your <img src="img/turret_arc_small.png" alt="Turret Arc" title="Turret Arc">';
var ROTATE_ARC_TEXT2 = '<img src="img/action_rotatearc_small.png" alt="Rotate Turret Arc" title="Rotate Turret Arc"> if Target is not in <img src="img/turret_arc_small.png" alt="Turret Arc" title="Turret Arc">';
var ROTATE_ARC_TEXT3 = '<img src="img/action_rotatearc_small.png" alt="Rotate Turret Arc" title="Rotate Turret Arc"> to get a shot if Target is not in your <img src="img/turret_arc_small.png" alt="Turret Arc" title="Turret Arc">';
var ROTATE_ARC_TEXT4 = 'If target is not in your <img src="img/in_arc_bullseye.png" alt="Bullseye Arc" title="Bullseye Arc"> and is not in your <img src="img/turret_arc-red_small.png" alt="Turret Arc" title="Turret Arc">, execute Pinpoint Tractor Array Ship Ability to <img src="img/action_rotatearc_small.png" alt="Rotate Turret Arc" title="Rotate Turret Arc"> onto the target and use tractor move for a shot.';
var ROTATE_ARC_TEXT5 = '<img src="img/action_rotatearc_small.png" alt="Rotate Turret Arc" title="Rotate Turret Arc"> to get a shot if you do not have a shot from your <img src="img/in_arc.png" alt="Forward Arc" title="Forward Arc">, <img src="img/in_rear_arc.png" alt="Rear Arc" title="Rear Arc">, or your <img src="img/turret_arc_small.png" alt="Turret Arc" title="Turret Arc">';

var ROTATE_ARC_D_TEXT1 = '<img src="img/action_rotatearc-red.png" alt="Rotate Turret Arc (Difficult)" title="Rotate Turret Arc (Difficult)"> to get a shot if Target is neither in your <img src="img/in_arc.png" alt="Forward Arc" title="Forward Arc"> nor your <img src="img/turret_arc_small.png" alt="Turret Arc" title="Turret Arc">.' ;
var ROTATE_ARC_D_TEXT2 = '<img src="img/action_rotatearc-red.png" alt="Rotate Turret Arc (Difficult)" title="Rotate Turret Arc (Difficult)"> if Target is not in <img src="img/turret_arc_small.png" alt="Turret Arc" title="Turret Arc">';
var ROTATE_ARC_D_TEXT3 = '<img src="img/action_rotatearc-red.png" alt="Rotate Turret Arc (Difficult)" title="Rotate Turret Arc (Difficult)"> to get a shot if Target is not in your <img src="img/turret_arc_small.png" alt="Turret Arc" title="Turret Arc">';
var ROTATE2CALC_D_TEXT = 'OPTIONAL: Gain 1 <img src="img/action_calculate-red_small.png" alt="Calculate (Difficult)" title="Calculate (Difficult)"> token.';

var TO_ROTATE_ARC_TEXT = '<p>' + '...and perform <img src="img/action_to_rotate.png" alt="Rotate Turret Arc" title="Rotate Turret Arc"> if Target is in other <img src="img/turret_arc_small.png" alt="Turret Arc" title="Turret Arc"> arc.' + '</p>';
var TO_ROTATE_ARC_D_TEXT = '<p>' + '...and perform <img src="img/action_to_rotate-red.png" alt="Rotate Turret Arc (Difficult)" title="Rotate Turret Arc (Difficult)"> if Target is in other <img src="img/turret_arc_small.png" alt="Turret Arc" title="Turret Arc"> arc.' + '</p>';

var SLAM_TEXT1 = 'Choose <img src="img/action_slam.png" alt="SLAM" title="SLAM"> if this will put target into AI ship\'s firing arc.';
var SLAM_TEXT2 = 'Choose <img src="img/action_slam.png" alt="SLAM" title="SLAM"> if this will put the AI ship out of enemy ship firing arc.';

var TARGET_LOCK_TEXT =  'Take a Free <img src="img/action_targetlock_small.png" alt="Target-Lock" title="Target Lock">';
var TARGET_LOCK_D_TEXT = 'Take a <img src="img/action_targetlock-red_small.png" alt="Target-Lock (Difficult)" title="Target Lock (Difficult)"> if target has already moved and is in your <img src="img/in_arc_red.png" alt="Forward Arc" title="Forward Arc">. Gain 1 <img src="img/Stress_small.png" alt="Stress Token" title="Stress Token">. This is NOT a "Free Action" for the AI, since the <img src="img/action_targetlock-red_small.png" alt="Target-Lock (Difficult)" title="Target Lock (Difficult)"> action results in gaining a <img src="img/Stress_small.png" alt="Stress Token" title="Stress Token">.';
var TARGET_LOCK_F_TEXT = 'If you have a <img src="img/token_force_small.png" alt="Force Charge" title="Force Charge"> available, pay 1 <img src="img/token_force_small.png" alt="Force Charge" title="Force Charge"> to take a <img src="img/action_targetlock-purple_small.png" alt="Target-Lock (Force)" title="Target Lock (Force)"> as a free action.';

var BIGSHIP_TEXT = 'Huge ships get TWO actions per turn.';

//Define Big Ships in an array
var bigShips = [ "CR90 Corellian Corvette (Reb)", "CR90 Corellian Corvette (Rep)", "GR-75 Medium Transport (Reb)", "GR-75 Medium Transport (Res)", "Raider-class Corvette (FO)", "Raider-class Corvette (Imp)", "Gozanti-class Cruiser (FO)", "Gozanti-class Cruiser (Imp)", "C-ROC Cruiser (Sep)", "C-ROC Cruiser (Scum)", "Trident Class Assault Ship (Scum)", "Trident Class Assault Ship (Sep)" ];

//Define an array of ships that can have AstroMechs on board
var astroMechs = [ "ARC-170 Starfighter (Reb)", "ARC-170 Starfighter (Rep)", "BTA-NR2 Y-Wing", "BTL-A4 Y-Wing (Reb)", "BTL-A4 Y-Wing (Scum)", "BTL-B Y-Wing", "Delta-7 Aethersprite", "Delta-7B Aethersprite", "Eta-2 Actis", "E-Wing", "Fireball Racer", "M-12L Kimogila Fighter", "Naboo Royal N-1 Starfighter", "Nimbus-Class V-Wing", "Resistance Transport", "Sheathipede Shuttle (Phantom 2)", "T-65 X-Wing", "T-70 X-Wing", "VCX-100 Light Freighter (Ghost)" ];

//Define an array of ships that can carry bombs aboard as payloads
var bombers = [ "IG-2000 Agressor Assault Fighter", "A/SF-01 B-Wing", "BTA-NR2 Y-Wing", "BTL-A4 Y-Wing (Reb)", "BTL-A4 Y-Wing (Scum)", "BTL-B Y-Wing", "BTL-S8 K-Wing", "C-ROC Cruiser", "Firespray-31 (Scum)", "Firespray-31 (Sep)", "Gauntlet Fighter (Reb)", "Gauntlet Fighter (Imp)", "Gauntlet Fighter (Rep)", "Gauntlet Fighter (Scum)", "Gauntlet Fighter (Sep)", "Heavy Missile Platform (HMP) Droid Gunship", "HWK-290 Light Freighter (Reb)", "HWK-290 Light Freighter (Scum)", "Hyena-class Droid Bomber", "Hyena Droid Bomber/DBS-32C", "MG-100 StarFortress B-SF17", "Nimbus-Class V-Wing", "Quadrijet Transfer Spacetug (Quadjumper)", "Rogue-class Starfighter (Scum)", "Rogue-class Starfighter (Sep)", "Scurrg H-6 Bomber", "Sith Infiltrator", "TIE/ca Punisher", "TIE/sa Bomber", "TIE/se Bomber", "TIE/sk Striker", "VT-49 Decimator" ];

//Defines an array of ships that can potentially equip "Cloaking Device" upgrade (Illicit Cargo Upgrade), or a title or other ship or pilot ability to cloak/decloak
var cloakersSmall = [ "IG-2000 Agressor Assault Fighter", "BTL-A4 Y-Wing (Scum)", "Fireball Racer", "HWK-290 Light Freighter (Scum)", "Kihraxz Fighter", "Quadrijet Transfer Spacetug (Quadjumper)", "Rogue-class Starfighter (Scum)", "Z-95-AF4 Headhunter (Scum)" ];
var cloakersML = [ "C-ROC Cruiser (Scum)", "Customized YT-1300 Light Freighter", "Firespray-31 (Sep)", "Firespray-31 (Scum)", "G-1A (Mist Hunter) Starfighter", "Gauntlet Fighter (Scum)", "JumpMaster 5000 (Punishing One)", "Lancer Class Pursuit Craft (Shadow Caster)", "M-12L Kimogila Fighter", "Scavenged YT-1300 Light Freighter", "YT-2400 Light Freighter", "YV-666 Light Freighter (Hound's Tooth)" ];
var cloakersSpecial = [ "BTA-NR2 Y-Wing", "Sith Infiltrator", "T-65 X-Wing", "TIE/fo Fighter", "TIE/sf Fighter", "UT-60D U-Wing" ];
//ATTACKS (New for 2.5.1 Update)
var attacks = "";

//END PHASE (New for 2.5.1 Update)
var end = "";

// SHIPS array and currently selected SHIP (re-defined in separate xwing_ships2.js file)
var ships = [];
var SHIP = {};

// ****************************************************************************
// Moves

class Maneuver {
    constructor(name, distance) {
        this.name = name;
        this.num = distance;
    }
}

function F( distance ) {
    return new Maneuver("forward", distance);
}

function BL( distance ) {
    return new Maneuver("bank-left", distance);
}

function BR( distance ) {
    return new Maneuver("bank-right", distance);
}

function TL( distance ) {
    return new Maneuver("turn-left", distance);
}

function TR( distance ) {
    return new Maneuver("turn-right", distance);
}

function K( distance ) {
    return new Maneuver("koiogran", distance);
}

function SLL( distance ) {
    return new Maneuver("segnor-loop-left", distance);
}

function SLR( distance ) {
    return new Maneuver("segnor-loop-right", distance);
}

function TRL( distance ) {
    return new Maneuver("tallon-roll-left", distance);
}

function TRR( distance ) {
    return new Maneuver("tallon-roll-right", distance);
}

function RBL( distance ) {
    return new Maneuver("reverse-bank-left", distance);
}

function RBR( distance ) {
    return new Maneuver("reverse-bank-right", distance);
}

function R( distance ) {
    return new Maneuver("reverse", distance);
}

function STA( distance ) {
    return new Maneuver("stationary", distance);
}

function invalid() {
	return new Maneuver("invalid", 0);
}

// ****************************************************************************
// Helper Functions

function display_ship_choice( faction, funct )
{
    var data = "";
    var idx=0;
    var shown=0;

    data += '<form action="demo_form.asp" name="ship_buttons">';

    data += '<b>Faction:</b><br>';

    data += '<label>\n';
	data += '    <div title="Rebels">'
	data += '       <input type="radio" onclick="display_ship_choice(\'Rebel\', \'' + funct + '\')" hidden >'
	data += '        <img class="faction_button" src="img/rebel.png" />'
	data += '    </div>'
	data += '</label>\n';

    data += '<label>\n';
    data += '    <div title="Empire">'
    data += '       <input type="radio" onclick="display_ship_choice(\'Empire\', \'' + funct + '\')" hidden >'
    data += '       <img class="faction_button" src="img/empire.png" />'
    data += '    </div>'
    data += '</label>\n';

    data += '<br>\n';

    data += '<label>\n';
    data += '    <div title="Scum">'
    data += '       <input type="radio" onclick="display_ship_choice(\'Scum\', \'' + funct + '\')" hidden >'
    data += '        <img class="faction_button" src="img/scum.png" />'
    data += '    </div>'
    data += '</label>\n';

   	data += '<label>\n';
	data += '    <div title="Hotlist">'
	data += '       <input type="radio" onclick="display_ship_choice(\'Hotlist\', \'' + funct + '\')" hidden >'
	data += '        <img class="faction_button" src="img/Hotlist.png" />'
	data += '    </div>'
	data += '</label><br>';

    data += '<br>\n';

	data += '<label>\n';
	data += '    <div title="Resistance">'
	data += '       <input type="radio" onclick="display_ship_choice(\'Resistance\', \'' + funct + '\')" hidden >'
	data += '        <img class="faction_button" src="img/resistance.png" />'
	data += '    </div>'
    data += '</label>\n';

    data += '<label>\n';
	data += '    <div title="First Order">'
	data += '       <input type="radio" onclick="display_ship_choice(\'First Order\', \'' + funct + '\')" hidden >'
	data += '        <img class="faction_button" src="img/1storder.png" />'
	data += '    </div>'
    data += '</label>\n';

    data += '<br>\n';

	data += '<label>\n';
	data += '    <div title="Republic">'
	data += '       <input type="radio" onclick="display_ship_choice(\'Republic\', \'' + funct + '\')" hidden >'
	data += '        <img class="faction_button" src="img/republic.png" />'
	data += '    </div>'
    data += '</label>\n';

    data += '<label>\n';
	data += '    <div title="Seperatist">'
	data += '       <input type="radio" onclick="display_ship_choice(\'Seperatist\', \'' + funct + '\')" hidden >'
	data += '        <img class="faction_button" src="img/seperatist.png" />'
	data += '    </div>'
	data += '</label>\n';

    data += '<br>\n';

    data += '<b>AI Ship:</b><br>';

    for( idx=0; idx < ships.length; idx++ )
    {
        // only add buttons for ships for the selected faction
        if( ships[idx].faction == faction )
        {
            // run the selected function on the first faction ship found
            if( shown == 0 )
            {
                var fn = window[funct];
                fn(idx);
            }

            shown++;
            funct_args = funct + "(" + idx + ")";

            data += '<label>\n';
            data += '    <div title="' + ships[idx].name + '">'
            data += '       <input type="radio" onclick="' + funct_args + '" hidden />'
            data += '       <img class="ship_button" src="' + ships[idx].image + '" />'
            data += '    </div>'
            data += '</label>\n';

            if( shown % 2 == 0 )
            {
                data += '<br>\n'
            }
        }
        // If Hotlist selected, only add buttons for ships in the Hotlist
        else if( (HOTLIST.includes(ships[idx].name) ) && (faction == "Hotlist") )
        {
            // run the selected function on the first hotlist ship found
            if( shown == 0 )
            {
                var fn = window[funct];
                fn(idx);
            }

            shown++;
            funct_args = funct + "(" + idx + ")";

            data += '<label>\n';
            data += '    <div title="' + ships[idx].name + '">'
            data += '       <input type="radio" onclick="' + funct_args + '" hidden />'
            data += '       <img class="ship_button" src="' + ships[idx].image + '" />'
            data += '    </div>'
            data += '</label>\n';

            if( shown % 2 == 0 )
            {
                data += '<br>\n'
            }
        }
    }

    data += '<br>\n';
    data += '</form>\n';
    document.getElementById( "ships" ).innerHTML = data;
}

// Generates the Maneuver Table for display in the HTML Ships page
function gen_maneuver_table( name, table )
{
    var data;
    data = '<div class="label">' + name + "</div>";
    data += '<table class="ship_table">';
    for( var dir=0; dir < table.length; dir++ )
    {
        data += "<tr><td class=\"ship_cell\">" + DIRECTION[dir];
        for( var item=0; item < table[dir].length; item++ )
        {
            maneuver = format_maneuver( SHIP, table[dir][item] );
            data += "<td class=\"ship_cell\">";
            data += '<div class="table_num">' + maneuver.num + '</div>';
            data += '<div class="table_num">' + maneuver.img + '</div>';
            data += "</td>";
        }
        data += "</tr>";
    }
    data += "</table><br>";
    return data;
}

// HTML Ships Display Page
function display_ship( ship_id )
{
    // Set the global to the selected ship
    SHIP = ships[ ship_id ];
    if (SHIP === undefined )
    {
    	var error = "<div><p>Unable to get ship(" + ship_id + ")</div>";
    	document.getElementById( "table" ).innerHTML( error );
    	return;
    }

    //reset Bomber Decision Table
	deviceType = 0;
	deviceName = "NONE";
	document.getElementById('postsystem-text').innerHTML = format_postsystem( SHIP, deviceType, deviceName );

    // image
    ship = '<img src="' + SHIP.image + '" alt="' + SHIP.name + '"><br>' + SHIP.name + "<br>" + "Faction: " + SHIP.faction;

    stats =  format_stats( SHIP );

    planning = format_planning( SHIP );

    system =  format_system( SHIP );

    targets =  format_targets( SHIP );

    preMove = format_preMove( SHIP );

    fullthrottle = format_fullthrottle( SHIP );

    actions =  format_actions( SHIP );

    attacks =  format_attacks( SHIP );

    end =  format_end( SHIP );

    // Tables (closing, away, etc.)
    var tables = "";
    tables += gen_maneuver_table( CLOSING, SHIP.closing )
    tables += gen_maneuver_table( AWAY, SHIP.away )
    tables += gen_maneuver_table( FAR, SHIP.far )
    tables += gen_maneuver_table( STRESSED, SHIP.stressed )

    // Output to HTML
    document.getElementById( "version" ).innerHTML = "XWingAI2 Version: " + VERSION;
    document.getElementById( "ship").innerHTML = ship;
    document.getElementById( "stats" ).innerHTML = stats;
    document.getElementById( "planning" ).innerHTML = planning;
    document.getElementById( "system" ).innerHTML = system;
    document.getElementById( "targets" ).innerHTML = targets;
    document.getElementById( "preMove" ).innerHTML = preMove;
    document.getElementById( "fullthrottle" ).innerHTML = fullthrottle;
    document.getElementById( "actions" ).innerHTML = actions;
    document.getElementById( "attacks" ).innerHTML = attacks;
    document.getElementById( "end" ).innerHTML = end;
    document.getElementById( "table" ).innerHTML = tables;
}


function set_version()
{
    document.getElementById('version').innerHTML = "XWingAI2 Version: " + VERSION;
}


function set_ship( ship_id )
{
    // Set the global to the selected ship
    SHIP = ships[ ship_id ];
    if (SHIP === undefined ) {
    	document.getElementById('ship_name').innerHTML = "<br>Unknown Ship: " + ship_id;
    	return;
    }

    set_version();

	//reset image map
	image_map = 'img/FGA_image_map.png' ;

	//reset Bomber Decision Table
	deviceType = 0;
	deviceName = "NONE";
	document.getElementById('postsystem-text').innerHTML = format_postsystem( SHIP, deviceType, deviceName );

    // Update index html elements for the selected ship
   	document.getElementById('ship_image').src = SHIP.image;
   	document.getElementById('ship_name').innerHTML = "<br>" + SHIP.name + "<br>" + "Faction: " + SHIP.faction;
	document.getElementById( "map_img").src = image_map;

    // Clear any previous maneuvers shown
    document.getElementById('closing_num').innerHTML = "<p></p>";
    document.getElementById('closing_img').innerHTML = "<p></p>";
    document.getElementById('away_num').innerHTML = "<p></p>";
    document.getElementById('away_img').innerHTML = "<p></p>";
    document.getElementById('far_num').innerHTML = "<p></p>";
    document.getElementById('far_img').innerHTML = "<p></p>";
    document.getElementById('stressed_num').innerHTML = "<p></p>";
    document.getElementById('stressed_img').innerHTML = "<p></p>";

    document.getElementById('selection').innerHTML = "<p>Click on the location of target ship</p>";
    document.getElementById('stats-text').innerHTML = format_stats( SHIP );
    document.getElementById('planning-text').innerHTML = format_planning( SHIP );
    document.getElementById('system-text').innerHTML = format_system( SHIP );
    document.getElementById('postsystem-text').innerHTML = format_postsystem( SHIP, deviceType, deviceName );
    document.getElementById('targets-text').innerHTML = format_targets( SHIP );
    document.getElementById('preMove-text').innerHTML = format_preMove( SHIP );
    document.getElementById('noStress-text').innerHTML = noStress;
    document.getElementById('fullthrottle-text').innerHTML = format_fullthrottle( SHIP );
    document.getElementById('actions-text').innerHTML = format_actions( SHIP );
    document.getElementById('attacks-text').innerHTML = format_attacks( SHIP );
    document.getElementById('end-text').innerHTML = format_end( SHIP );
}


function pick( options )
{
	if (options === undefined)
	{
		return invalid();
	}

	var size=options.length;
	if ( size == 0 )
	{
		return invalid();
	}
    var choice=Math.floor(Math.random()*size);
    return options[choice];
}

function maneuverInList( maneuver, list )
{
    var found = false;
    for( var i=0; i < list.length; i++ )
    {
        if( ( list[i].num == maneuver.num ) && ( list[i].name == maneuver.name ) )
        {
            found = true;
            break;
        }
    }

    return found;
}


function format_maneuver( ship, maneuver )
{
    var num;
    var img;

    if ( maneuverInList( maneuver, ship.simple ) )
    {
        num = "<span style=color:#1e8eff>" + maneuver.num + "</span>";
        img = '<img src="img/' + maneuver.name + '-blue.png">';
    }
    else if ( maneuverInList( maneuver, ship.difficult ) )
    {
        num = "<span style=color:red>" + maneuver.num + "</span>";
        img = '<img src="img/' + maneuver.name + '-red.png">';
    }
    else if ( maneuverInList( maneuver, ship.force ) )
    {
        num = "<span style=color:purple>" + maneuver.num + "</span>";
        img = '<img src="img/' + maneuver.name + '-purple.png">';
    }
    else if ( maneuverInList( maneuver, ship.normal ) )
    {
        num = "<span>" + maneuver.num + "</span>";
        img = '<img src="img/' + maneuver.name + '-white.png">';
    }
    else {
        num = "<span style=color:purple>NA</span>";
        img = "";
    }

    return {'num': num, 'img': img };
}

function format_stats( ship )
{
	stats = "";
	stats += "<p>" + "<img src=\'img/" + ship.init + "\' alt='Initiative: " + ship.init.charAt(0) + "\' title='Initiative: " + ship.init.charAt(0) + "'\>   Pilot: " + ship.pilot + "</p>";
	stats += "<p>" + "<img src=\'img/" + ship.stats + "\' alt='Ship Stats' title='Ship Stats'>" + "</p>";
	stats += "<p>" + "<img src=\'img/" + ship.icons + "\' alt='Action Icons' title='Action Icons'>" + "</p>";

	for( var abils = 0; abils < ship.ability.length; abils++ )
    {
		switch( ship.ability[ abils ] )
		{
			case "NONE":
			{
				break;
			}
			case "ADVANCED_TARGETING_COMPUTER":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "ADVANCED TARGETING COMPUTER" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you perform a primary attack against a defender you have locked, roll 1 additional die and change 1 <img src='img/damage.png' alt='Damage' title='Damage'> result into a <img src='img/critical_small.png' alt='Critical Damage' title='Critical Damage'> result." + "</p>";
				break;
			}
			case "NIMBLE_BOMBER":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "NIMBLE BOMBER" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "If you would drop a device using a <img src='img/forward-white_small.png' alt='Forward Template' title='Forward Template'>, you may use a <img src='img/bank-left-white_small.png' alt='Bank Left Template' title='Bank Left Template'> or <img src='img/bank-right-white_small.png' alt='Bank Right Template' title='Bank Right Template'> of the same speed instead." + "</p>";
				break;
			}
			case "FULL_THROTTLE":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "FULL THROTTLE" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "After you fully execute a speed 3-5 maneuver, you may perform an <img src='img/action_evade_small.png' alt='Evade' title='Evade'> action." + "</p>";
				break;
			}
			case "AUTOTHRUSTERS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "AUTOTHRUSTERS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "After you perform an action, you may perform a red <img src='img/action_barrelroll-red_small.png' alt='Barrel Roll (Difficult)' title='Barrel Roll (Difficult)'> or a red <img src='img/action_boost-red_small.png' alt='Boost (Difficult)' title='Boost (Difficult)'>action." + "</p>";
				break;
			}
			case "STYGIUM_ARRAY":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "STYGIUM ARRAY" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "After you decloak, you may perform" + "<br>" + "an <img src='img/action_evade_small.png' alt='Evade' title='Evade'> action." + "</p>";
				stats += "<p style=\"text-align: left\">" + "At the start of the End Phase, you may spend 1 evade token to gain 1 cloak token." + "</p>";
				break;
			}
			case "HEAVY_WEAPON_TURRET":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "HEAVY WEAPON TURRET" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "You can rotate your <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> indicator only to your <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> or <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'>." + "<br>";
				stats += "You must treat the <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> requirement of your equipped <img src='img/token_missile_small.png' alt='Missile' title='Missile'> upgrades as <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'>." + "</p>";
				break;
			}
			case "VECTORED_THRUSTERS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "VECTORED THRUSTERS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "After you perform an action, you may perform a red <img src='img/action_boost-red_small.png' alt='Boost (Difficult)' title='Boost (Difficult)'> action." + "</p>";
				break;
			}
			case "SENSOR_BLINDSPOT":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "SENSOR BLINDSPOT" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you perform a primary attack at attack range 0-1, do not apply the range 0-1 bonus and roll 1 fewer attack die." + "</p>";
				break;
			}
			case "TAIL_GUN":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "TAIL GUN" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you have a docked ship, you have a primary weapon with an <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'> attack value equal to your docked ship\'s primary <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> attack value." + "</p>";
				break;
			}
			case "DEADMANS_SWITCH":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "DEADMAN'S SWITCH" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "After you are destroyed, each other ship at range 0-1 suffers 1 <img src='img/damage.png' alt='Damage' title='Damage'>." + "</p>";
				break;
			}
			case "WEAPON_HARDPOINT":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "WEAPON HARDPOINT" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "You can equip 1 <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'> or <img src='img/token_missile_small.png' alt='Missile' title='Missile'> upgrade." + "</p>";
				break;
			}
			case "MICROTHRUSTERS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "MICROTHRUSTERS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you perform a barrel roll, you <b>must</b> use the <img src='img/bank-left-white_small.png' alt='Bank Left' title='Bank Left'> or <img src='img/bank-right-white_small.png' alt='Bank Right' title='Bank Right'> template instead of the <img src='img/forward-white_small.png' alt='Forward' title='Forward'> template." + "</p>";
				break;
			}
			case "CONCORDIA_FACEOFF":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "CONCORDIA FACEOFF" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you defend, if the attack range is 1 and you are in the attacker's forward arc, change 1 result to a <img src='img/action_evade_small.png' alt='Evade' title='Evade'> result." + "</p>";
				break;
			}
			case "NOTCHED_STABILIZERS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "NOTCHED STABILIZERS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you move, you ignore asteroids." + "</p>";
				break;
			}
			case "FINE_TUNED_CONTROLS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "FINE-TUNED CONTROLS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "After you fully execute a maneuver, you may spend 1 <img src='img/token_force_small.png' alt='Force Token' title='Force Token'> to perform a <img src='img/action_boost_small.png' alt='Boost' title='Boost'> or <img src='img/action_barrelroll_small.png' alt='Barrel Roll' title='Barrel Roll'> action." + "</p>";
				break;
			}
			case "FINE_TUNED_THRUSTERS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "FINE-TUNED THRUSTERS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "After you fully execute a maneuver, if you are not depleted or strained, you may gain 1 <img src='img/token_depleted.png' alt='Deplete Token' title='Deplete Token'> or 1 <img src='img/token_strain.png' alt='Strain Token' title='Strain Token'> to perform a <img src='img/action_targetlock_small.png' alt='Target Lock' title='Target Lock'> or <img src='img/action_barrelroll_small.png' alt='Barrel Roll' title='Barrel Roll'> action." + "</p>";
				break;
			}
			case "PLATED_HULL":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "PLATED HULL" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you defend, if you are not critically damaged, change 1 <img src='img/critical_small.png' alt='Critical Damage' title='Critical Damage'> result to a <img src='img/damage.png' alt='Damage' title='Damage'> result." + "</p>";
				break;
			}
			case "TRACTOR_GRASP":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "TRACTOR GRASP" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "After you perform a Tractor Tentacles attack that hits, the defender gains 1 <img src='img/token_tractor.png' alt='Tractor Token' title='Tractor Token'>." + "</p>";
				break;
			}
			case "EXPERIMENTAL_SCANNERS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "EXPERIMENTAL SCANNERS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "You may acquire <img src='img/action_targetlock_small.png' alt='Target Locks' title='Target Locks'> beyond range 3. You cannot acquire <img src='img/action_targetlock_small.png' alt='Target Locks' title='Target Locks'> at range 1." + "</p>";
				break;
			}
			case "CO-PILOT":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "CO-PILOT" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "Pilot Dependent: While you are docked, your carrier ship has your pilot ability in addition to its own." + "</p>";
				break;
			}
			case "RIGGED_ENERGY_CELLS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "RIGGED ENERGY CELLS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "Autopilot Drone Pilot Only: During the System Phase, if you are not docked, lose 1 <img src='img/token_charge_small.png' alt='Charge Token' title='Charge Token'>." + "<br>";
				stats += "At the end of the Activation Phase, if you have 0 <img src='img/token_charge_small.png' alt='Charge Tokens' title='Charge Tokens'>, you are destroyed. Before you are removed, each ship at range 0-1 suffers 1 <img src='img/critical_small.png' alt='Critical' title='Critical'> damage." + "</p>";
				break;
			}
			case "REFINED_GYROSTABILIZERS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "REFINED_GYROSTABILIZERS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "You can rotate your <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> indicator only to your <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> or <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'>." + "<br>";
				stats += "After you perform an action, you may perform a red <img src='img/action_boost-red_small.png' alt='Boost (Difficult)' title='Boost (Difficult)'> action or a red <img src='img/action_rotatearc-red.png' alt='Rotate Arc (Difficult)' title='Rotate Arc (Difficult)'> action." + "</p>";
				break;
			}
			case "NETWORKED_CALCULATIONS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "NETWORKED CALCULATIONS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you defend or perform an attack, you may spend 1 <img src='img/action_calculate_small.png' alt='Calculate Token' title='Calculate Token'> from a friendly ship at range 0-1 to change 1 <img src='img/action_focus_small.png' alt='Focus' title='Focus'> result to a(n) <img src='img/action_evade_small.png' alt='Evade' title='Evade'> or <img src='img/damage.png' alt='Damage' title='Damage'> result." + "</p>";
				break;
			}
			case "NETWORKED_AIM":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "NETWORKED AIM" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "You cannot spend your <img src='img/action_targetlock_small.png' alt='Target Locks' title='Target Locks'> to reroll attack dice" + "<br>";
				stats += "While you perform an attack, you may reroll a number of attack dice up to the number of friendly <img src='img/action_targetlock_small.png' alt='Target Locks' title='Target Locks'> on the defender." + "</p>";
				break;
			}
			case "PINPOINT_TRACTOR_ARRAY":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "PINPOINT TRACTOR ARRAY" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "You cannot rotate your <img src='img/turret_arc-red_small.png' alt='Turret Arc' title='Turret Arc'> to your <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'>." + "<br>";
				stats += "After you execute a maneuver, you may gain 1 <img src='img/token_tractor.png' alt='Tractor Token' title='Tractor Token'> to perform a <img src='img/action_rotatearc_small.png' alt='Rotate Turret' title='Rotate Turret'> action." + "</p>";
				break;
			}
			case "EXPLOSION_WITH_WINGS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "EXPLOSION WITH WINGS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "During SETUP: You are dealt 1 face-down damage card." + "<br>";
				stats += "After you perform a <img src='img/action_slam.png' alt='SLAM' title='SLAM'> action, you may expose 1 damage card to remove 1 <img src='img/token_disarm.png' alt='Disarm Token' title='Disarm Token'>." + "</p>";
				break;
			}
			case "FIRE_CONVERGENCE":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "FIRE CONVERGENCE" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While a friendly ship performs a non-<img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> attack, if the defender is in your <img src='img/turret_dual_small.png' alt='Turret Arc' title='Turret Arc'>, you may spend 1 <img src='img/token_charge_small.png' alt='Charge Token' title='Charge Token'>." + "<br>";
				stats += "If you do, the attacker rerolls up to 2 attack dice." + "</p>";
				break;
			}
			case "ROTATING_CANNONS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "ROTATING CANNONS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "You can rotate your <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> indicator only to your <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> or <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'>." + "<br>";
				stats += "You must treat the <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> requirement of your equipped <img src='img/token_cannon_small.png' alt='Cannon' title='Cannon'> upgrades as <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'>." + "</p>";
				break;
			}
			case "INTUITIVE_CONTROLS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "INTUITIVE CONTROLS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "During the " + "<b>" + "System Phase" + "</b>" + ", you may spend 1 <img src='img/token_force_small.png' alt='Force Token' title='Force Token'> to perform a <img src='img/action_boost-purple_small.png' alt='Boost (Force)' title='Boost (Force)'> or <img src='img/action_barrelroll-purple_small.png' alt='Barrel Roll (Force)' title='Barrel Roll (Force)'> action." + "</p>";
				break;
			}
			case "TWIN_ION_ENGINES":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "TWIN ION ENGINES" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "Ignore the \'TIE\' ship restrictions on upgrade cards." + "</p>";
				break;
			}
			case "BROADSIDE_BATTERIES":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "BROADSIDE BATTERIES" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "You can acquire locks and perform primary attacks at range 1-4." + "</p>";
				break;
			}
			case "CONCENTRATED_BATTERIES":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "CONCENTRATED BATTERIES" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you perform a primary, <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, or <img src='img/token_missile_small.png' alt='Missile' title='Missile'> attack, if the defender is in your <img src='img/in_arc_bullseye.png' alt='Bullseye Arc' title='Bullseye Arc'>, roll 1 additional die." + "</p>";
				break;
			}
			case "RESUPPLY_CRAFT":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "RESUPPLY CRAFT" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "After another friendly ship at range 0-1 performs an action, you may spend 1 <img src='img/energy_small.png' alt='Energy' title='Energy'>. If you do, it removes 1 orange or red token, or recovers 1 shield." + "</p>";
				break;
			}
			case "DOCKING_CLAMPS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "DOCKING CLAMPS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "You can dock up to 4 small ships." + "</p>";
				break;
			}
			case "OVERDRIVE_BURNERS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "OVERDRIVE BURNERS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you defend, if your revealed maneuver is speed 3-5, roll 1 additional defense die." + "</p>";
				break;
			}
			case "SENSOR_BLINDSPOT":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "SENSOR BLINDSPOT" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you perform a primary attack at attack range 0-1, do not apply the range 0-1 bonus and roll 1 fewer attack die." + "</p>";
				break;
			}
			case "ADVANCED_DROID_BRAIN":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "ADVANCED DROID BRAIN" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "After you perform a <img src='img/action_calculate_small.png' alt='Calculate' title='Calculate'> action, gain 1  <img src='img/token_calculate.png' alt='Calculate Token' title='Calculate Token'>." + "</p>";
				break;
			}
			case "LOCKED_AND_LOADED":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "LOCKED AND LOADED" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you are docked, after your carrier ship performs a primary <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> or <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> attack, it may perform a bonus primary <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'> attack." + "</p>";
				break;
			}
			case "ADAPTIVE_AILERONS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "ADAPTIVE AILERONS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "Before you reveal your dial, if you are not stressed, you must execute a white <img src='img/1BL_white.png' alt='1BL Normal' title='1BL Normal'>, <img src='img/1F_white.png' alt='1F Normal' title='1F Normal'> or <img src='img/1BR_white.png' alt='1BR Normal' title='1BR Normal'> maneuver." + "</p>";
				break;
			}
			case "SPACETUG_TRACTOR_ARRAY":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "SPACETUG TRACTOR ARRAY" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "<b>" + "ACTION: " + "</b>" + "Choose a ship in your <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> at range 1. That ship gains 1 <img src='img/token_tractor.png' alt='Tractor Token' title='Tractor Token'> or 2 <img src='img/token_tractor.png' alt='Tractor Tokens' title='Tractor Tokens'> if it is in your <img src='img/in_arc_bullseye.png' alt='Bullseye Arc' title='Bullseye Arc'> at range 1." + "</p>";
				break;
			}
			case "LINKED_BATTERY":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "LINKED BATTERY" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you perform a <img src='img/token_cannon_small.png' alt='Cannon' title='Cannon'> attack, roll 1 additional die." + "</p>";
				break;
			}
			case "COMMS_SHUTTLE":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "COMMS SHUTTLE" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you are docked, your carrier ship gains <img src='img/action_coordinate_small.png' alt='Coordinate' title='Coordinate'>. Before your carrier ship activates, it may perform a <img src='img/action_coordinate_small.png' alt='Coordinate' title='Coordinate'> action." + "</p>";
				break;
			}
			case "DEAD_TO_RIGHTS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "DEAD TO RIGHTS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "While you perform an attack, if the defender is in your <img src='img/in_arc_bullseye.png' alt='Bullseye Arc' title='Bullseye Arc'>, defense dice cannot be modified using green tokens." + "</p>";
				break;
			}
			case "PURSUIT_THRUSTERS":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "PURSUIT THRUSTERS" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "During the " + "<b>" + "System Phase" + "</b>" + ", you may perform a <img src='img/action_boost_small.png' alt='Boost' title='Boost'> action." + "</p>";
				break;
			}
			case "VERSATILE_FRAME":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "VERSATILE FRAME" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "You can equip 1 <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'> or <img src='img/token_missile_small.png' alt='Missile' title='Missile'> upgrade. you may perform a <img src='img/action_boost_small.png' alt='Boost' title='Boost'> action." + "<br>";
				stats += "While your revealed maneuver is blue, add white <img src='img/action_boost_small.png' alt='Boost' title='Boost'> to your action bar." + "</p>";
				break;
			}
			case "INTUITIVE_INTERFACE":
			{
				stats += "<p>" + "Ship Ability: " + "<b>" + "INTUITIVE INTERFACE" + "</b>" + "</p>";
				stats += "<p style=\"text-align: left\">" + "After you perform an action added to your action bar by a <img src='img/Upgrade_Talent.png' alt='Talent Upgrade' title='Talent Upgrade'> , <img src='img/Upgrade_Illicit.png' alt='Illicit Upgrade' title='Illicit Upgrade'> , or <img src='img/Upgrade_Mod.png' alt='Modification Upgrade' title='Modification Upgrade'> upgrade, you may perform a <img src='img/action_calculate_small.png' alt='Calculate' title='Calculate'> action." + "</p>";
				break;
			}
			default:
			{
				stats += "<p>" + "Ability Mismatch" + "</p>";
			}
		}
	}
	stats += "<p><b>Maneuver Table</b>" + "<br>";
	stats += "<img src=\'img/" + ship.table + "\' alt='Maneuver Table' title='Maneuver Table'>" + "<br>";
	stats += "<span style=\"font-size: 12px\">Maneuver Tables courtesy of <a class=label href=\"http://xhud.sirjorj.com/xwing.cgi\">xhud.sirjorj.com</a></span></p>";
	return stats;
}

function format_planning (ship)
{
	planning = "";
	planning += "<p class=\"label\">" + "Planning Phase" + "</p>";
	planning += "Human players set maneuver dials. Ionized ships are not assigned dials." + "<br><br>";
	if( cloakersSmall.includes(SHIP.name) )
	{
		planning += "For ships with a Cloaking Device equipped:" + "<br>";
		planning += "<ol>" + "<li>" + "Roll 1 attack die. On a <img src='img/action_focus_small.png' alt='Focus' title='Focus'> result, decloak or discard your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>";
		var decloakRoll = pick(DECLOAK_DIEROLL);
		if(decloakRoll == "B" )
		{
		planning += "<img src='img/dice_attack_blank_small.png' alt='Blank' title='Blank'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "H" )
		{
		planning += "<img src='img/dice_attack_hit_small.png' alt='Hit' title='Hit'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "C" )
		{
		planning += "<img src='img/dice_attack_crit_small.png' alt='Critical Hit' title='Critical Hit'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "F" )
		{
		planning += "<img src='img/dice_attack_focus_small.png' alt='Focus' title='Focus'> Decloaking is REQUIRED. Follow the steps below to decloak." + "</li>";
		}
		planning += "<li>" + "If required to decloak, take this action: (reroll if blocked - click on ship again to reroll)" + "<br>" + "<br>";
		var decloaking = pick(DECLOAK_SMALL);
			if(decloaking == "2L" )
			{
				planning += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/action_barrelroll_left-blue_small.png' alt='Barrel Roll Left' title='Barrel Roll Left'>" + "</li>";
			}
			else if(decloaking == "2R" )
			{
				planning += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/action_barrelroll_right-blue_small.png' alt='Barrel Roll Right' title='Barrel Roll Right'>" + "</li>";
			}
			else
			{
				planning += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/forward-blue_small.png' alt='Boost Straight' title='Boost Straight'>" + "</li>";
			}
		planning += "<li>" + "Remove your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>" + "</ol>";
	}
	else if( cloakersML.includes(SHIP.name) )
	{
		planning += "For ships with a Cloaking Device equipped:" + "<br>";
		planning += "<ol>" + "<li>" + "Roll 1 attack die. On a <img src='img/action_focus_small.png' alt='Focus' title='Focus'> result, decloak or discard your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>";
		var decloakRoll = pick(DECLOAK_DIEROLL);
		if(decloakRoll == "B" )
		{
		planning += "<img src='img/dice_attack_blank_small.png' alt='Blank' title='Blank'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "H" )
		{
		planning += "<img src='img/dice_attack_hit_small.png' alt='Hit' title='Hit'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "C" )
		{
		planning += "<img src='img/dice_attack_crit_small.png' alt='Critical Hit' title='Critical Hit'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "F" )
		{
		planning += "<img src='img/dice_attack_focus_small.png' alt='Focus' title='Focus'> Decloaking is REQUIRED. Follow the steps below to decloak." + "</li>";
		}
		planning += "<li>" + "If required to decloak, take this action: (reroll if blocked - click on ship again to reroll)" + "<br>" + "<br>";
		var decloaking = pick(DECLOAK_MED_LG);
			if(decloaking == "1L" )
			{
				planning += "<img src='img/1-blue.png' alt='1 Simple' title='1 Simple'>   <img src='img/action_barrelroll_left-blue_small.png' alt='Barrel Roll Left' title='Barrel Roll Left'>" + "</li>";
			}
			else if(decloaking == "1R" )
			{
				planning += "<img src='img/1-blue.png' alt='1 Simple' title='1 Simple'>   <img src='img/action_barrelroll_right-blue_small.png' alt='Barrel Roll Right' title='Barrel Roll Right'>" + "</li>";
			}
			else
			{
				planning += "<img src='img/1-blue.png' alt='1 Simple' title='1 Simple'>   <img src='img/forward-blue_small.png' alt='Straight' title='Straight'>" + "</li>";
			}
		planning += "<li>" + "Remove your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>" + "</ol>";
	}
	else if (ship.name == "BTA-NR2 Y-Wing")
	{
		planning += "For ships with a Cloaking Device equipped (Pilots Zarii Bliss, Corus Kapellim, or Kijimi Spice Runner only):" + "<br>";
		planning += "<ol>" + "<li>" + "Roll 1 attack die. On a <img src='img/action_focus_small.png' alt='Focus' title='Focus'> result, decloak or discard your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>";
		var decloakRoll = pick(DECLOAK_DIEROLL);
		if(decloakRoll == "B" )
		{
		planning += "<img src='img/dice_attack_blank_small.png' alt='Blank' title='Blank'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "H" )
		{
		planning += "<img src='img/dice_attack_hit_small.png' alt='Hit' title='Hit'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "C" )
		{
		planning += "<img src='img/dice_attack_crit_small.png' alt='Critical Hit' title='Critical Hit'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "F" )
		{
		planning += "<img src='img/dice_attack_focus_small.png' alt='Focus' title='Focus'> Decloaking is REQUIRED. Follow the steps below to decloak." + "</li>";
		}
		planning += "<li>" + " If required to decloak, take this action: (reroll if blocked - click on ship again to reroll)" + "<br>" + "<br>";
		var decloaking = pick(DECLOAK_SMALL);
			if(decloaking == "2L" )
			{
				planning += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/action_barrelroll_left-blue_small.png' alt='Barrel Roll Left' title='Barrel Roll Left'>" + "</li>";
			}
			else if(decloaking == "2R" )
			{
				planning += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/action_barrelroll_right-blue_small.png' alt='Barrel Roll Right' title='Barrel Roll Right'>" + "</li>";
			}
			else
			{
				planning += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/forward-blue_small.png' alt='Straight' title='Straight'>" + "</li>";
			}
		planning += "<li>" + "Remove your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>" + "</ol>";
	}
	else if (ship.name == "UT-60D U-Wing")
	{
		planning += "For ships with a Cloaking Device equipped (Pilots Saw Gerrera, Magva Yarro, Benthic Two Tubes, or Partisan Renegade only):" + "<br>";
		planning += "<ol>" + "<li>" + "Roll 1 attack die. On a <img src='img/action_focus_small.png' alt='Focus' title='Focus'> result, decloak or discard your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>";
		var decloakRoll = pick(DECLOAK_DIEROLL);
		if(decloakRoll == "B" )
		{
		planning += "<img src='img/dice_attack_blank_small.png' alt='Blank' title='Blank'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "H" )
		{
		planning += "<img src='img/dice_attack_hit_small.png' alt='Hit' title='Hit'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "C" )
		{
		planning += "<img src='img/dice_attack_crit_small.png' alt='Critical Hit' title='Critical Hit'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "F" )
		{
		planning += "<img src='img/dice_attack_focus_small.png' alt='Focus' title='Focus'> Decloaking is REQUIRED. Follow the steps below to decloak." + "</li>";
		}
		planning += "<li>" + "If required to decloak, take this action: (reroll if blocked - click on ship again to reroll)" + "<br>" + "<br>";
		var decloaking = pick(DECLOAK_MED_LG);
			if(decloaking == "1L" )
			{
				planning += "<img src='img/1-blue.png' alt='1 Simple' title='1 Simple'>   <img src='img/action_barrelroll_left-blue_small.png' alt='Barrel Roll Left' title='Barrel Roll Left'>" + "</li>";
			}
			else if(decloaking == "1R" )
			{
				planning += "<img src='img/1-blue.png' alt='1 Simple' title='1 Simple'>   <img src='img/action_barrelroll_right-blue_small.png' alt='Barrel Roll Right' title='Barrel Roll Right'>" + "</li>";
			}
			else
			{
				planning += "<img src='img/1-blue.png' alt='1 Simple' title='1 Simple'>   <img src='img/forward-blue_small.png' alt='Straight' title='Straight'>" + "</li>";
			}
		planning += "<li>" + "Remove your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>" + "</ol>";
	}
	else if (ship.name == "T-65 X-Wing")
	{
		planning += "For ships with a Cloaking Device equipped (Pilots Edrio Two Tubes or Cavern Angels Zealot only):" + "<br>";
		planning += "<ol>" + "<li>" + "Roll 1 attack die. On a <img src='img/action_focus_small.png' alt='Focus' title='Focus'> result, decloak or discard your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>";
		var decloakRoll = pick(DECLOAK_DIEROLL);
		if(decloakRoll == "B" )
		{
		planning += "<img src='img/dice_attack_blank_small.png' alt='Blank' title='Blank'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "H" )
		{
		planning += "<img src='img/dice_attack_hit_small.png' alt='Hit' title='Hit'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "C" )
		{
		planning += "<img src='img/dice_attack_crit_small.png' alt='Critical Hit' title='Critical Hit'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "F" )
		{
		planning += "<img src='img/dice_attack_focus_small.png' alt='Focus' title='Focus'> Decloaking is REQUIRED. Follow the steps below to decloak." + "</li>";
		}
		planning += "<li>" + "If required to decloak, take this action: (reroll if blocked - click on ship again to reroll)" + "<br>" + "<br>";
		var decloaking = pick(DECLOAK_SMALL);
			if(decloaking == "2L" )
			{
				planning += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/action_barrelroll_left-blue_small.png' alt='Barrel Roll Left' title='Barrel Roll Left'>" + "</li>";
			}
			else if(decloaking == "2R" )
			{
				planning += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/action_barrelroll_right-blue_small.png' alt='Barrel Roll Right' title='Barrel Roll Right'>" + "</li>";
			}
			else
			{
				planning += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/forward-blue_small.png' alt='Straight' title='Straight'>" + "</li>";
			}
		planning += "<li>" + "Remove your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>" + "</ol>";
	}
	else if ( (ship.name == "TIE/fo Fighter") || (ship.name == "TIE/sf Special Forces") )
	{
		planning += "For ships with a Cloaking Device (equipped by Xi Class Light Shuttle Pilot Agent Terrex only):" + "<br>";
		planning += "<ol>" + "<li>" + "Roll 1 attack die. On a <img src='img/action_focus_small.png' alt='Focus' title='Focus'> result, decloak or discard your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>";
		var decloakRoll = pick(DECLOAK_DIEROLL);
		if(decloakRoll == "B" )
		{
		planning += "<img src='img/dice_attack_blank_small.png' alt='Blank' title='Blank'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "H" )
		{
		planning += "<img src='img/dice_attack_hit_small.png' alt='Hit' title='Hit'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "C" )
		{
		planning += "<img src='img/dice_attack_crit_small.png' alt='Critical Hit' title='Critical Hit'> Decloaking not allowed in this phase. You may decloak in the Systems Phase." + "</li>";
		}
		else if(decloakRoll == "F" )
		{
		planning += "<img src='img/dice_attack_focus_small.png' alt='Focus' title='Focus'> Decloaking is REQUIRED. Follow the steps below to decloak." + "</li>";
		}
		planning += "<li>" + "If required to decloak, take this action: (reroll if blocked - click on ship again to reroll)" + "<br>" + "<br>";
		var decloaking = pick(DECLOAK_SMALL);
			if(decloaking == "2L" )
			{
				planning += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/action_barrelroll_left-blue_small.png' alt='Barrel Roll Left' title='Barrel Roll Left'>" + "</li>";
			}
			else if(decloaking == "2R" )
			{
				planning += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/action_barrelroll_right-blue_small.png' alt='Barrel Roll Right' title='Barrel Roll Right'>" + "</li>";
			}
			else
			{
				planning += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/forward-blue_small.png' alt='Straight' title='Straight'>" + "</li>";
			}
		planning += "<li>" + "Remove your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>" + "</ol>";
	}
	else if (ship.name == "Sith Infiltrator")
	{
		planning += "If you have the \'Scimitar\' Title and you are cloaked, you may decloak:" + "<br>";
		planning += "<ol>" + "<li>" + "If you wish to attempt to decloak, take this action: (reroll if blocked - click on ship again to reroll)" + "<br>" + "<br>";
		var decloaking = pick(DECLOAK_MED_LG);
			if(decloaking == "1L" )
			{
				planning += "<img src='img/1-blue.png' alt='1 Simple' title='1 Simple'>   <img src='img/action_barrelroll_left-blue_small.png' alt='Barrel Roll Left' title='Barrel Roll Left'>" + "</li>";
			}
			else if(decloaking == "1R" )
			{
				planning += "<img src='img/1-blue.png' alt='1 Simple' title='1 Simple'>   <img src='img/action_barrelroll_right-blue_small.png' alt='Barrel Roll Right' title='Barrel Roll Right'>" + "</li>";
			}
			else
			{
				planning += "<img src='img/1-blue.png' alt='1 Simple' title='1 Simple'>   <img src='img/forward-blue_small.png' alt='Straight' title='Straight'>" + "</li>";
			}
		planning += "<li>" + "If you cannot execute any of these movements, your ship may not decloak this turn." + "</li>";
		planning += "<li>" + "If you decloaked successfully, remove your <img src='img/token_cloak.png' alt='Cloak Token' title='Cloak Token'>." + "</li>" + "</ol>";
	}
	return planning;
}

function format_system( ship )
{
	system = "";
	system += "<p class=\"label\">" + "System Phase" + "</p>";
	system += "<ol>" + "<li>" + "Deploy/dock ships." + "</li>";

	if( (cloakersSmall.includes (SHIP.name) ) || (cloakersML.includes (SHIP.name) ) || (cloakersSpecial.includes (SHIP.name) ) )
	{
	system += "<li>" + "OPTIONAL: If you are cloaked, you may decloak. Follow steps 2 and 3 above for your decloaking move. No die roll is required." + "<br>";
	system += "If you cannot successfully decloak, you remain cloaked." + "</li>";
	}

	if( ship.name == "TIE/ph Phantom" )
	{
		system += "<li>" + "OPTIONAL: Decloak." + "<br>";
		system += "1) Execute the following movement (reroll if blocked - Click on Phantom again to reroll):" + "<br>" + "<br>";
		var decloaking = pick(DECLOAK_SMALL);
			if(decloaking == "2L" )
			{
				system += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/action_barrelroll_left-blue_small.png' alt='Barrel Roll Left' title='Barrel Roll Left'>" + "</li>" + "<br>";
			}
			else if(decloaking == "2R" )
			{
				system += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/action_barrelroll_right-blue_small.png' alt='Barrel Roll Right' title='Barrel Roll Right'>" + "</li>" + "<br>";
			}
			else
			{
				system += "<img src='img/2-blue.png' alt='2 Simple' title='2 Simple'>   <img src='img/forward-blue_small.png' alt='Straight' title='Straight'>" + "</li>" + "<br>";
			}
		system += "<li>" + "2) If you cannot execute any of these movements, the AI ship may not decloak this turn." + "</li>";
		system += "<li>" + "3) If you decloaked successfully, perform an <img src='img/action_evade-blue_small.png' alt='Evade' title='Evade'> action." + "</li>" + "</ol>";
	}

	if (ship.name == "Eta-2 Actis" )
	{
		system += "<li>" + "During the System Phase, you may spend 1 <img src='img/token_force_small.png' alt='Force Token' title='Force Token'> to perform a <img src='img/action_boost-purple_small.png' alt='Boost (Force)' title='Boost (Force)'> or <img src='img/action_barrelroll-purple_small.png' alt='Barrel Roll (Force)' title='Barrel Roll (Force)'> action." + "</li>";
	}
	else if (ship.name == "Escape Craft" )
	{
		system += "<li>" + "Escape Craft with Autopilot Drone Pilot only: if you are not docked, lose 1 <img src='img/token_charge_small.png' alt='Charge Token' title='Charge Token'>." + "</li>";
	}
	else if (ship.name == "TIE/se Bomber" )
	{
		system += "<li>" + "OPTIONAL: Use PURSUIT THRUSTERS ship ability to perform a <img src='img/action_boost_small.png' alt='Boost' title='Boost'> action to get a shot or to get out of an enemy\'s arc." + "</li>";
	}

	if ( bombers.includes(SHIP.name) || (cloakersSmall.includes (SHIP.name)) || (cloakersML.includes (SHIP.name)) || (cloakersSpecial.includes (SHIP.name)) )
	{
		system += "<li>" + "You may Drop/Launch/Relocate <img src='img/payload_small.png' alt='Devices' title='Devices'>.";
		if ( (cloakersSmall.includes (SHIP.name) ) || (cloakersML.includes (SHIP.name) ) || (cloakersSpecial.includes (SHIP.name) ) )
		{
			system += " You may NOT Drop/Launch/Relocate <img src='img/payload_small.png' alt='Devices' title='Devices'> if you decloaked during this phase." + "</li>" + "</ol>";
		}
		else
		{
			system += "</li></ol>"
		}
	}

	if( (bombers.includes(SHIP.name)) || (cloakersSmall.includes (SHIP.name)) || (cloakersML.includes (SHIP.name)) || (cloakersSpecial.includes (SHIP.name)) )
	{
		system += "<p>" + "Select <img src='img/payload_small.png' alt='Payload' title='Payload'> to analyze from the dropdown list:</p>";
		system += "<div class='dropdown'>";
		system += "<button class='dropbtn'>Payload Selection<img src='img/dropdown.png' alt='Dropdown Arrow' title='Dropdown Arrow'></button>";
		system += "<div class='dropdown-content'>";
		if( bombers.includes(SHIP.name) )
		{
			system += "<p onclick='displayLogic(SHIP, 0, \"'NONE\")'>NONE</p>";
			system += "<p onclick='displayLogic(SHIP, 2, \"Blazer Bomb\")'>Blazer Bomb</p>";
			system += "<p onclick='displayLogic(SHIP, 2, \"Bomblet\")'>Bomblet</p>";
			system += "<p onclick='displayLogic(SHIP, 1, \"Cluster Mine\")'>Cluster Mine</p>";
			system += "<p onclick='displayLogic(SHIP, 2, \"Concussion Bomb\")'>Concussion Bomb</p>";
			system += "<p onclick='displayLogic(SHIP, 1, \"Connor Net\")'>Connor Net</p>";
			system += "<p onclick='displayLogic(SHIP, 2, \"Electro-Proton Bomb\")'>Electro-Proton Bomb</p>";
			system += "<p onclick='displayLogic(SHIP, 2, \"Ion Bomb\")'>Ion Bomb</p>";
			system += "<p onclick='displayLogic(SHIP, 2, \"Proton Bomb\")'>Proton Bomb</p>";
			system += "<p onclick='displayLogic(SHIP, 1, \"Proximity Mine\")'>Proximity Mine</p>";
			system += "<p onclick='displayLogic(SHIP, 2, \"Thermal Detonator\")'>Thermal Detonator</p>";
			system += "<p onclick='displayLogic(SHIP, 2, \"Seismic Charge\")'>Seismic Charge</p>";
			system += "<p onclick='displayLogic(SHIP, 1, \"Remote\")'>Remotes</p>";
		}
		if( (cloakersSmall.includes (SHIP.name)) || (cloakersML.includes (SHIP.name)) || (cloakersSpecial.includes (SHIP.name)) )
		{
			system += "<p onclick='displayLogic(SHIP, 1, \"Cargo Drift\")'>Cargo Drift</p>";
			system += "<p onclick='displayLogic(SHIP, 1, \"Loose Cargo\")'>Loose Cargo</p>";
			system += "<p onclick='displayLogic(SHIP, 1, \"Spare Parts\")'>Spare Parts</p>";
			system += "</div></div>";
		}
		else
		{
			system += "</div></div>";
		}
	}
	return system;
}

//Displays the correct Logic Chart for Payload decisions
function displayLogic(ship, Type, dName)
{
	deviceType = Type;
	deviceName = dName;
//	alert("displayLogic activated. deviceType= " + JSON.stringify(deviceType) + " deviceName= " + deviceName);
	document.getElementById('postsystem-text').innerHTML = format_postsystem(SHIP, deviceType, deviceName);
}

function format_postsystem (ship, deviceType, deviceName)
{
	postsystem = "";
	if( (bombers.includes(SHIP.name)) || (cloakersSmall.includes (SHIP.name)) || (cloakersML.includes (SHIP.name)) || (cloakersSpecial.includes (SHIP.name)) )
	{
		if( deviceType == 1 )
		{
			postsystem += "Device: " + deviceName + "<br>Device Type: Class A (Movement)" + "<br><br>";
			postsystem += "<img src='img/devicelogic1.png' alt='Movement Devices' title='Movement Devices'><br>";
//			postsystem += "deviceType is " + deviceType + "<br>";
			postsystem += "<p> Attack dice roll:</p>";
			var deviceDrop = pick(ATTACKDIE);
				if(deviceDrop == "B" )
				{
					postsystem += "<div class='attackDie'><img src='img/dice_attack_blank_small.png' alt='Blank' title='Blank'></div>" + "<br>";
				}
				else if(deviceDrop == "F" )
				{
					postsystem += "<div class='attackDie'><img src='img/dice_attack_focus_small.png' alt='Focus' title='Focus'></div>" + "<br>";
				}
				else if(deviceDrop == "H" )
				{
					postsystem += "<div class='attackDie'><img src='img/dice_attack_hit_small.png' alt='Hit' title='Hit'></div>" + "<br>";
				}
				else if(deviceDrop == "C" )
				{
					postsystem += "<div class='attackDie'><img src='img/dice_attack_crit_small.png' alt='Critical' title='Critical'></div>" + "<br>";
				}
				else
				{
					postsystem += "";
				}
		}
		else if( deviceType == 2 )
		{
			postsystem += "Device: " + deviceName + "<br>Device Type: Class B (Timing)" + "<br><br>";
			postsystem += "<img src='img/devicelogic2.png' alt='Timing Devices' title='Timing Devices'><br>";
//			postsystem += "deviceType is " + deviceType + "<br>";
			postsystem += "<p> Attack dice roll:</p>";
			var deviceDrop = pick(ATTACKDIE);
			if(deviceDrop == "B" )
				{
					postsystem += "<div class='attackDie'><img src='img/dice_attack_blank_small.png' alt='Blank' title='Blank'></div>" + "<br>";
				}
				else if(deviceDrop == "F" )
				{
					postsystem += "<div class='attackDie'><img src='img/dice_attack_focus_small.png' alt='Focus' title='Focus'></div>" + "<br>";
				}
				else if(deviceDrop == "H" )
				{
					postsystem += "<div class='attackDie'><img src='img/dice_attack_hit_small.png' alt='Hit' title='Hit'></div>" + "</li>" + "<br>";
				}
				else if(deviceDrop == "C" )
				{
					postsystem += "<div class='attackDie'><img src='img/dice_attack_crit_small.png' alt='Critical' title='Critical'></div>" + "<br>";
				}
		}
		else
		{
			postsystem += "";
		}
	}
	deviceType = 0;
	Type = 0;
	deviceName = "NONE";
	dName = "NONE";
	deviceDrop = "N";
	return postsystem;
}

function format_targets( ship )
{
	targets = "<ol>";
	ship.targets.forEach(targetText);
	targets += "</ol>";
	return targets;
}


function targetText( value, index, array )
{
	switch( value )
	{
    	case 'LOCKED':
    	{
        	targets += "<li>" + "Locked enemy within Range 3" + "</li>";
        	break;
    	}
    	case 'LOWERI':
    	{
        	targets += "<li>" + "Nearest enemy in <img src='img/in_arc.png' alt='firing arc' title='Firing Arc'> " + "with lower Initiative" + "</li>";
        	break;
    	}
    	case 'LOWERI_FULL':
    	{
        	targets += "<li>" + "Nearest enemy in <img src='img/in_full_arc_front.png' alt='Front Full Arc' title='Front Full Arc'> " + "with lower Initiative" + "</li>";
        	break;
    	}
    	case 'LOWERI_TURRET':
    	{
        	targets += "<li>" + "Nearest enemy in <img src='img/turret_arc_small.png' alt='Turret Arc arc' title='Turret Arc arc'> " + "with lower Initiative" + "</li>";
        	break;
    	}
       	case 'ARC':
       	{
           	targets += "<li>" + "Nearest enemy in <img src='img/in_arc.png' alt='Front firing arc' title='Front Firing Arc'>" + "</li>";
           	break;
       	}
       	case 'ARC_FULL':
       	{
           	targets += "<li>" + "Nearest enemy in <img src='img/in_full_arc_front.png' alt='Front Full arc' title='Front Full Arc'>" + "</li>";
           	break;
       	}
       	case 'ARC_TURRET':
       	{
           	targets += "<li>" + "Nearest enemy in <img src='img/turret_arc_small.png' alt='Turret Arc arc' title='Turret Arc arc'>" + "</li>";
           	break;
       	}
       	case 'REAR_ARC':
       	{
           	targets += "<li>" + "Nearest enemy in <img src='img/in_rear_arc.png' alt='Rear firing arc' title='Rear Firing Arc'>" + "</li>";
           	break;
       	}
       	case 'NEAREST':
       	{
           	targets += "<li>" + "Nearest enemy" + "</li>";
           	break;
    	}
	    default:
	    {
			targets += "<li>" + "No Actions Found" + "</li>";
		}
	}
}

function format_preMove( ship )
{
	preMove = "";
	if( (ship.name == "TIE/sk Striker" ) || (ship.name == "TIE Reaper" ) )
	{
		preMove += "<p>" + "Conduct ADAPTIVE AILERONS maneuver.";
		preMove += "Execute the following maneuver (reroll if blocked - Click on ship again to reroll):" + "<br>" + "<br>";
				var adaptiveAilerons = pick(DECLOAK_MED_LG);
					if(adaptiveAilerons == "1L" )
					{
						preMove += "<p style='text-align:center;'>" + "<img src='img/1BL_white.png' alt='1 Bank Left' title='1 Bank Left'>" + "</p>";
					}
					else if(adaptiveAilerons == "1R" )
					{
						preMove += "<p style='text-align:center;'>" + "<img src='img/1BR_white.png' alt='1 Bank Right' title='1 Bank Right'>" + "</p>";
					}
					else
					{
						preMove += "<p style='text-align:center;'>" + "<img src='img/1F_white.png' alt='1 Forward' title='1 Forward'>" + "</p>";
					}
				preMove += "If you cannot fully execute any of these maneuvers without a bump or overlap, select the least damaging maneuver." + "</p>";
	}
	return preMove;
}

function format_fullthrottle( ship )
{
	fullthrottle = "";
	if( (ship.name == "TIE/D Defender" ) || (ship.name == "Naboo Royal N-1 Starfighter" ) )
	{
		fullthrottle += "<p>" + "<img src='img/action_evade_small.png' alt='Evade' title='Evade'> if allowed due to " + "<i>" + "<b>" + "FULL THROTTLE" + "</b>" + "</i>" + " ability" + "</p>";
	}
	else if( ship.name == "Escape Craft" )
	{
		fullthrottle += "<p>" + "Escape Craft with Autopilot Drone Pilot only: At the end of the Activation Phase, if you have 0 <img src='img/token_charge_small.png' alt='Charge Tokens' title='Charge Tokens'>, you are destroyed. Before you are removed, each ship at range 0-1 suffers 1 <img src='img/critical_small.png' alt='Critical' title='Critical'> damage." + "</p>";
	}
	else if( ship.name == "TIE/ba Interceptor" )
	{
		fullthrottle += FOCUS_TEXT3 + "<br><br>";
	}
	else if( (ship.name == "Delta-7 Aethersprite") || (ship.name == "Delta-7B Aethersprite") )
	{
		fullthrottle += "<p>" + "OPTIONAL: Use FINE-TUNED CONTROLS ship ability:" + "<br>";
		fullthrottle += "<ul>" + BARREL_ROLL_OR_BOOST_TEXT4 + "</ul>" + "</p>";
	}
	return fullthrottle;
}


function format_actions( ship )
{
	actions = "";
	labelTest = 0;
	reloadTest = 0;
	evadeTest = 0;
	focusTest = 0;
	rotateTest = 0;
	reinforceTest = 0;

	actions += "<ol>";
	if( bigShips.includes(SHIP.name) )
	{
		actions += BIGSHIP_TEXT;
	}
	actions += "<li>" + "Resolve <img src='img/critical_small.png' alt='Criticals' title='Criticals'>";
	if ( astroMechs.includes(SHIP.name) )
	{
		actions += " or repair with <img src='img/astromech.png' alt='Astromech' title='Astromech'>" + "</li>";
	}
	else
	{
		actions += "</li>";
	}
	moveicon = ship.faction.toLowerCase();
	switch( ship.name )
	{
    	case 'VT-49 Decimator':
    	{
        	labelTest = 2;
        	rotateTest = 2;
        	break;
    	}
       	case 'TIE Interceptor':
       	{
			focusTest = 2;
			labelTest = 2;
			evadeTest = 4;
           	break;
    	}
    	case 'TIE Advanced x1':
    	{
			labelTest = 2;
			break;
    	}

       	case 'TIE/D Defender':
       	{
			labelTest = 1;
			evadeTest = 1;
           	break;
    	}
       	case 'TIE Advanced v1 (Inquisitor)':
       	{
			evadeTest = 3;
           	break;
    	}
       	case 'TIE/ba Interceptor':
       	{
			labelTest = 2;
			evadeTest = 2;
           	break;
    	}
       	case 'TIE/ph Phantom':
       	{
			evadeTest = 1;
           	break;
    	}
       	case 'T-65 X-Wing':
       	{
			labelTest = 2;
           	break;
       	}
       	case 'T-70 X-Wing':
       	{
			labelTest = 2;
           	break;
       	}
       	case 'BTL-A4 Y-Wing (Reb)':
       	{
			reloadTest = 1;
			rotateTest = 1;
           	break;
    	}
       	case 'RZ-1 A-Wing':
       	{
			focusTest = 3;
			labelTest = 2;
			evadeTest = 2;

           	break;
    	}
       	case 'RZ-2 A-Wing':
       	{
			labelTest = 2;
			evadeTest = 3;
			rotateTest = 3;

           	break;
    	}
       	case 'V-19 Torrent':
       	{
			focusTest = 1;
			labelTest = 1;
           	break;
    	}
       	case 'Sith Infiltrator':
       	{
			cloakTest = 1;
			focusTest = 1;
			labelTest = 1;
           	break;
    	}
       	case 'Delta-7 Aethersprite':
       	{
			labelTest = 2;
           	break;
    	}
       	case 'Delta-7B Aethersprite':
       	{
			labelTest = 2;
           	break;
    	}
       	case 'Eta-2 Actis':
       	{
			labelTest = 2;
           	break;
    	}
       	case 'E-Wing':
       	{
			evadeTest = 2;
           	break;
    	}
       	case 'A/SF-01 B-Wing':
       	{
			labelTest = 2;
           	break;
    	}
       	case 'YT-2400 Light Freighter':
       	{
			labelTest = 1;
			rotateTest = 2;
           	break;
    	}
       	case 'Modified YT-1300 Light Freighter':
       	{
			rotateTest = 3;
           	break;
    	}
       	case 'Customized YT-1300 Light Freighter':
       	{
			rotateTest = 3;
           	break;
    	}
       	case 'Scavenged YT-1300 Light Freighter':
       	{
			rotateTest = 3;
           	break;
    	}
       	case 'VCX-100 Light Freighter (Ghost)':
       	{
			rotateTest = 5;
			reinforceTest = 3;
           	break;
    	}
       	case 'BTL-A4 Y-Wing (Scum)':
       	{
			reloadTest = 1;
			rotateTest = 1;
           	break;
    	}
       	case 'BTL-B Y-Wing':
       	{
			reloadTest = 1;
			rotateTest = 1;
           	break;
    	}
       	case 'BTA-NR2 Y-Wing':
       	{
			rotateTest = 1;
           	break;
    	}
       	case 'Kihraxz Fighter':
       	{
			focusTest = 1;
           	break;
    	}
       	case 'HWK-290 Light Freighter (Reb)':
       	{
			rotateTest = 2;
           	break;
    	}
       	case 'HWK-290 Light Freighter (Scum)':
       	{
			rotateTest = 2;
           	break;
    	}
       	case 'Firespray-31 (Scum)':
       	{
			labelTest = 1;
           	break;
    	}
       	case 'Firespray-31 (Sep)':
       	{
			labelTest = 1;
           	break;
    	}
       	case 'Naboo Royal N-1 Starfighter':
       	{
			labelTest = 1;
           	break;
    	}
       	case 'Nantex-class Starfighter':
       	{
			rotateTest = 4;
           	break;
    	}
       	case 'Resistance Transport Pod':
       	{
			labelTest = 1;
           	break;
    	}
       	case 'Fireball Racer':
       	{
			labelTest = 1;
           	break;
    	}
       	case 'Heavy Missile Platform (HMP) Droid Gunship':
       	{
			labelTest = 1;
           	break;
    	}
       	case 'Low Altitude Attack Transport/improved (LAAT/i)':
       	{
			rotateTest = 3;
           	break;
    	}
    	case 'Droid Tri-Fighter':
       	{
			evadeTest = 3;
           	break;
    	}
       	case 'CR90 Corellian Corvette (Reb)':
       	{
			reinforceTest = 2;
           	break;
    	}
       	case 'CR90 Corellian Corvette (Rep)':
       	{
			reinforceTest = 2;
           	break;
    	}
       	case 'C-ROC Cruiser (Scum)':
       	{
			reinforceTest = 2;
           	break;
    	}
       	case 'C-ROC Cruiser (Sep)':
       	{
			reinforceTest = 2;
           	break;
    	}
       	case 'Gozanti-class Cruiser (Imp)':
       	{
			reinforceTest = 2;
           	break;
    	}
       	case 'Gozanti-class Cruiser (FO)':
       	{
			reinforceTest = 2;
           	break;
    	}
       	case 'Raider-class Corvette (FO)':
       	{
			reinforceTest = 2;
           	break;
    	}
       	case 'Raider-class Corvette (Imp)':
       	{
			reinforceTest = 2;
           	break;
    	}
    	case 'IG-2000 Agressor Assault Fighter':
       	{
			evadeTest = 3;
           	break;
    	}
    	case 'M3-A Interceptor':
       	{
			evadeTest = 3;
           	break;
    	}
       	case 'YV-666 Light Freighter (Hound\'s Tooth)':
       	{
			reinforceTest = 1;
           	break;
    	}
       	case 'BTL-S8 K-Wing':
       	{
			rotateTest = 3;
           	break;
    	}
    	case 'Phantom Attack Shuttle':
       	{
			evadeTest = 3;
           	break;
    	}
       	case 'G-1A (Mist Hunter) Starfighter':
       	{
			labelTest = 1;
           	break;
    	}
    	case 'Lancer Class Pursuit Craft (Shadow Caster)':
       	{
			evadeTest = 3;
			rotateTest = 3;
           	break;
    	}
       	case 'TIE/sk Striker':
       	{
			evadeTest = 3;
           	break;
    	}
       	case 'Auzituck Gunship':
       	{
			reinforceTest = 1;
           	break;
    	}
       	case 'TIE/ag Aggressor':
       	{
			rotateTest = 5;
           	break;
    	}
       	case 'Scurrg H-6 Bomber':
       	{
			rotateTest = 5;
           	break;
    	}
       	case 'MG-100 StarFortress B-SF17':
       	{
			rotateTest = 5;
           	break;
    	}
       	case 'TIE Reaper':
       	{
			focusTest = 4;
           	break;
    	}
       	case 'TIE/vn Silencer':
       	{
			labelTest = 1;
           	break;
    	}
       	case 'Auzituck Gunship':
       	{
			reinforceTest = 2;
           	break;
    	}
    	case 'ST-70 Assault (Razor Crest)':
       	{
			evadeTest = 3;
           	break;
    	}
    	case 'TIE/wi Whisper':
       	{
			evadeTest = 3;
           	break;
    	}
	    default:
	    {
			cloakTest = 0;
			labelTest = 0;
			reloadTest = 0;
			evadeTest = 0;
			rotateTest = 0;
			reinforceTest = 0;
		}
	}

	ship.actions.forEach(actionText);

	actions += "</ol>";

	if( labelTest == 2 )
	{
		actions += "   <img src='img/tgt_movement-green_small_" + moveicon + ".png' alt='Only if Target has already moved' title='Only if Target has already moved'> = only if Target has " + "<u>" + "already" + "</u>" + " moved" + "<p>" + "</p>";
		actions += "   <img src='img/tgt_movement-red_small_" + moveicon + ".png' alt='Only if Target has not yet moved' title='Only if Target has not yet moved'> = only if Target has " + "<u>" + "not" + "</u>" + " " + "<u>" + "yet" + "</u>" + " moved" + "<br>";
	}
	else if( labelTest == 1 )
	{
		actions += "   <img src='img/tgt_movement-green_small_" + moveicon + ".png' alt='Only if Target has already moved' title='Only if Target has already moved'> = only if Target has " + "<u>" + "already" + "</u>" + " moved" + "<p>" + "</p>";
	}
	else
	{
		actions += "";
	}
	if( ship.name == "RZ-2 A-Wing" )
	{
		actions += "OPTIONAL: Use REFINED GYROSTABILIZERS ship ability:" + "<br>";
		actions += "<ul>" + BOOST_D_TEXT1 + "</ul>";
		actions += "<ul>" + ROTATE_ARC_D_TEXT3 + "</ul>";
	}
	else if( ship.name == "RZ-1 A-Wing" )
	{
		actions += "OPTIONAL: Use VECTORED THRUSTERS ship ability:" + "<br>";
		actions += "<ul>" + BOOST_D_TEXT1 + "</ul>";
	}
	else if( ship.name == "TIE/vn Silencer" )
	{
		actions += "OPTIONAL: Use AUTOTHRUSTERS ship ability:" + "<br>";
		actions += "<ul>" + BOOST_D_TEXT1 + "</ul>";
		actions += "<ul>" + BARREL_ROLL_D_TEXT5 + "</ul>";
	}
	actions += "<p>" + "Unless fused, <img src='img/payload_small.png' alt='Bombs' title='Bombs'>  detonate at the END of the Activation Phase." + "<br>";
	actions += "Remove 1 fuse token from each fused <img src='img/payload_small.png' alt='Bomb' title='Bomb'>." + "</p>";
	return actions;
}


function actionText( value, index, array )
{
	switch( value )
	{
    	case 'BARREL_ROLL_AVOID':
    	{
        	actions += "<li>" + BARREL_ROLL_TEXT1 + "</li>";
        	break;
    	}
    	case 'BARREL_ROLL_D_AVOID':
    	{
        	actions += "<li>" + BARREL_ROLL_D_TEXT1 + "</li>";
        	break;
    	}
    	case 'BARREL_ROLL_SHOT':
    	{
        	actions += "<li>" + BARREL_ROLL_TEXT2 + "</li>";
        	break;
    	}
    	case 'BARREL_ROLL_D_SHOT':
    	{
        	actions += "<li>" + BARREL_ROLL_D_TEXT2 + "</li>";
        	break;
    	}
    	case 'BARREL_ROLL_AVOID_SHOT':
    	{
        	actions += "<li>" + BARREL_ROLL_TEXT3 + "</li>";
        	break;
    	}
    	case 'BARREL_ROLL_D_AVOID_SHOT':
    	{
        	actions += "<li>" + BARREL_ROLL_D_TEXT3 + "</li>";
        	break;
    	}
   	case 'BARREL_ROLL_D_M_R2':
    	{
        	actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BARREL_ROLL_D_TEXT4 + "</li>";
        	break;
    	}
    	case 'BARREL_ROLL_M_AVOID':
    	{
        	actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BARREL_ROLL_TEXT1 + "</li>";
        	break;
    	}
    	case 'BARREL_ROLL_M_SHOT':
    	{
        	actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BARREL_ROLL_TEXT2 + "</li>";
        	break;
    	}
    	case 'BARREL_ROLL_M_AVOID_SHOT':
    	{
        	actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BARREL_ROLL_TEXT3 + "</li>";
        	break;
    	}
		case 'BARREL_ROLL_D_M':
		{
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BARREL_ROLL_D_TEXT3 + "</li>";
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BARREL_ROLL_D_TEXT2 + "</li>";
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BARREL_ROLL_D_TEXT1 + "</li>";
			break;
	    }
		case 'BARREL_ROLL2CALC_D':
	    {
			actions += "<li>" + BARREL_ROLL2CALC_D_TEXT1 + "</li>";
			actions += "<li>" + BARREL_ROLL2CALC_D_TEXT2 + "</li>";
			break;
	    }
		case 'BARREL_ROLL2EVADE_D':
		{
			actions += "<li>" + BARREL_ROLL2EVADE_D_TEXT1 + "</li>";
			actions += "<li>" + BARREL_ROLL2EVADE_D_TEXT2 + "</li>";
			break;
	    }
		case 'BARREL_ROLL2LOCK_D':
		{
			actions += "<li>" + BARREL_ROLL2LOCK_D_TEXT1 + "</li>";
			actions += "<li>" + BARREL_ROLL2LOCK_D_TEXT2 + "</li>";
			break;
	    }
		case 'BOOST2LOCK_D':
		{
			actions += "<li>" + BOOST2LOCK_D_TEXT1 + "</li>";
			actions += "<li>" + BOOST2LOCK_D_TEXT2 + "</li>";
			break;
	    }
	    case 'BARREL_ROLL2ROTATE':
	    {
			actions += "<li>" + BARREL_ROLL_TEXT1 + "</li>";
			actions += "<li>" + BARREL_ROLL_TEXT2 + "</li>";
			actions += "<li>" + BARREL_ROLL2ROTATE_TEXT + "</li>";
			break;
		}
	    case 'BARREL_ROLL2ROTATE_D':
	    {
			actions += "<li>" + BARREL_ROLL_TEXT1 + "</li>";
			actions += "<li>" + BARREL_ROLL_TEXT2 + "</li>";
			actions += "<li>" + BARREL_ROLL2ROTATE_D_TEXT + "</li>";
			break;
		}
		case 'BARREL_ROLL_OR_BOOST':
		{
			actions += "<li>" + BARREL_ROLL_OR_BOOST_TEXT2 + "</li>";
			actions += "<li>" + BARREL_ROLL_OR_BOOST_TEXT1 + "</li>";
			actions += "<li>" + BARREL_ROLL_OR_BOOST_TEXT3 + "</li>";
			break;
	    }
		case 'BARREL_ROLL_OR_BOOST_M':
		{
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BARREL_ROLL_OR_BOOST_TEXT2 + "</li>";
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BARREL_ROLL_OR_BOOST_TEXT1 + "</li>";
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BARREL_ROLL_OR_BOOST_TEXT3 + "</li>";
			break;
	    }
		case 'BARREL_ROLL_OR_BOOST_F':
		{
			actions += "Use FINE-TUNED CONTROLS ship ability to:";
			actions += "<li>" + BARREL_ROLL_OR_BOOST_TEXT2 + "</li>";
			actions += "<li>" + BARREL_ROLL_OR_BOOST_TEXT1 + "</li>";
			actions += "<li>" + BARREL_ROLL_OR_BOOST_TEXT3 + "</li>";
			break;
	    }
		case 'BOOST':
		{
			actions += "<li>" + BOOST_TEXT2 + "</li>";
			actions += "<li>" + BOOST_TEXT1 + "</li>";
			actions += "<li>" + BOOST_TEXT3 + "</li>";
			break;
	    }
    	case 'BOOST_D':
    	{
        	actions += "<li>" + BOOST_D_TEXT1 + "</li>";
        	break;
    	}
		case 'BOOST_M':
		{
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BOOST_TEXT2 + "</li>";
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BOOST_TEXT1 + "</li>";
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BOOST_TEXT3 + "</li>";
			break;
	    }
	    case 'BOOST2CALC_D':
	    {
			actions += "<li>" + BOOST2CALC_D_TEXT1 + "</li>";
			actions += "<li>" + BOOST2CALC_D_TEXT2 + "</li>";
			break;
	    }
		case 'BOOST2ROTATE':
	    {
		    actions += "<li>" + BOOST_TEXT1 + "</li>";
		    actions += "<li>" + BOOST_TEXT2 + "</li>";
		    actions += "<li>" + BOOST2ROTATE_TEXT + "</li>";
		    break;
 	    }
		case 'BOOST_OR_BARREL_ROLL_M_SHOT':
		{
		    actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BOOST_OR_BARREL_ROLL_M_TEXT1 + "</li>";
			break;
	    }
		case 'BOOST_OR_BARREL_ROLL_AVOID':
		{
		    actions += "<li>" + BOOST_OR_BARREL_ROLL_M_TEXT2 + "</li>";
			break;
	    }
		case 'BOOST_OR_BARREL_ROLL_M_AVOID':
		{
		    actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + BOOST_OR_BARREL_ROLL_M_TEXT2 + "</li>";
			break;
	    }
		case 'BOOST_OR_BARREL_ROLL2FOCUS_D':
		{
			actions += "<li>" + BOOST_OR_BARREL_ROLL2FOCUS_D_TEXT1 + "</li>";
			actions += "<li>" + BOOST_OR_BARREL_ROLL2FOCUS_D_TEXT2 + "</li>";
			actions += "<li>" + BOOST_OR_BARREL_ROLL2FOCUS_D_TEXT3 + "</li>";
			break;
	    }
		case 'BOOST_OR_BARREL_ROLL2FOCUS_OR_CALCULATE_D':
		{
			actions += "<li>" + BOOST_OR_BARREL_ROLL2FOCUS_OR_CALCULATE_D_TEXT1 + "</li>";
			actions += "<li>" + BOOST_OR_BARREL_ROLL2FOCUS_OR_CALCULATE_D_TEXT2 + "</li>";
			actions += "<li>" + BOOST_OR_BARREL_ROLL2FOCUS_OR_CALCULATE_D_TEXT3 + "</li>";
			break;
	    }
    	case 'CALCULATE':
	    {
		    actions += "<li>" + CALCULATE_TEXT + "</li>";
		    break;
 	    }
    	case 'CALCULATE_SHOT':
	    {
		    actions += "<li>" + CALCULATE_SHOT_TEXT + "</li>";
		    break;
 	    }
    	case 'CALCULATE_D':
	    {
		    actions += "<li>" + CALCULATE_D_TEXT + "</li>";
		    break;
 	    }
		case 'CLOAKING':
	    {
		   if( cloakTest == 1 )
		       {
		           actions += "<li>" + CLOAKING_TEXT1 + "</li>";
		           break;
		       }
			else
			   {
 	   	    		actions += "<li>" + CLOAKING_TEXT0 + "</li>";
 	   	    		break;
	   			}
	    }
	    case 'COORDINATE':
	    {
	        actions += "<li>" + COORDINATE_TEXT + "</li>";
	        break;
	    }
	    case 'COORDINATE_D':
	    {
   	        actions += "<li>" + COORDINATE_D_TEXT + "</li>";
	        break;
	    }
	    case 'EVADE':
	    {
		    if( evadeTest == 1 )
		        {
		            actions += "<li>" + EVADE_TEXT1 + "</li>";
		            break;
		        }
		        else if( evadeTest == 2 )
		        {
		            actions += "<li>" + "<img src='img/tgt_movement-red_small_" + moveicon + ".png' alt='Only if Target has not yet moved' title='Only if Target has not yet moved'>" + EVADE_TEXT2 + "</li>";
		            break;
		        }
		        else if( evadeTest == 3 )
		        {
		            actions += "<li>" + EVADE_TEXT3 + "</li>";
		            break;
		        }
		        else if( evadeTest == 4 )
		        {
		            actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + EVADE_TEXT2 + "</li>";
		            break;
		        }
		        else
		        {
					actions += "<li>" + EVADE_TEXT0 + "</li>";
					break;
				}
 	    }
	    case 'EVADE_D':
	    {
   	        actions += "<li>" + EVADE_D_TEXT + "</li>";
	        break;
	    }
	    case 'EVADE_F':
	    {
		    if( evadeTest == 1 )
		        {
		            actions += "<li>" + EVADE_F_TEXT1 + "</li>";
		            break;
		        }
		        else if( evadeTest == 2 )
		        {
		            actions += "<li>" + "<img src='img/tgt_movement-red_small_" + moveicon + ".png' alt='Only if Target has not yet moved' title='Only if Target has not yet moved'>" + EVADE_F_TEXT2 + "</li>";
		            break;
		        }
		        else
		        {
					actions += "<li>" + EVADE_F_TEXT0 + "</li>";
					break;
				}
 	    }
		case 'EVADE2BARREL_ROLL_D':
	    {
			actions += "<li>" + EVADE2BARREL_ROLL_D_TEXT2 + "</li>";
			break;
	    }
	    case 'EVADE2ROTATE':
	    {
			actions += "<li>" + EVADE2ROTATE_TEXT + "</li>";
			break;
		}
	    case 'EVADE2ROTATE_D':
	    {
			actions += "<li>" + EVADE2ROTATE_D_TEXT + "</li>";
			break;
		}
		case 'FOCUS':
		{
            if( focusTest == 4 )
            {
				actions += "<li>" + FOCUS_TEXT4 + "</li>";
            	break;
			}
			else
			{
				actions += "<li>" + FOCUS_TEXT1 + "</li>";
            	break;
			}
    	}
		case 'FOCUS_SHOT':
		{
            actions += "<li>" + FOCUS_TEXT2 + "</li>";
            break;
    	}
		case 'FOCUS_M':
		{
		    if( (focusTest == 0) || (focusTest == 1) || (focusTest == 3) )
		    {
		    	actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + FOCUS_TEXT1 + "</li>";
				break;
			}
		    else if( focusTest == 2 )
		    {
				actions += "<li>" + "<img src='img/tgt_movement-red_small_" + moveicon + ".png' alt='Only if Target has not yet moved' title='Only if Target has not yet moved'>" + FOCUS_TEXT1 + "</li>";
				break;
			}
			else
			{
				actions += "<li>" + FOCUS_TEXT1 + "</li>";
				break;
			}
    	}
		case 'FOCUS_M_SHOT':
		{
		    if( focusTest == 1 )
		    {
				actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + FOCUS_TEXT2 + "</li>";
           		break;
			}
			else if( (focusTest == 2) || (focusTest == 3) )
			{
				actions += "<li>" + "<img src='img/tgt_movement-red_small_" + moveicon + ".png' alt='Only if Target has not yet moved' title='Only if Target has not yet moved'>" + FOCUS_TEXT2 + "</li>";
           		break;
			}
			else
			{
				actions += "<li>" + FOCUS_TEXT2 + "</li>";
				break;
			}
    	}
		case 'FOCUS2BARREL_ROLL_D_M':
	    {
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + FOCUS2BARREL_ROLL_D_M_TEXT1 + "</li>";
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + FOCUS2BARREL_ROLL_D_M_TEXT2 + "</li>";
			break;
	    }
		case 'FOCUS2BOOST_D_M_SHOT':
	    {
			actions += "<li>" + FOCUS2BOOST_D_M_TEXT1 + "</li>";
			break;
	    }
		case 'F2B_F2BR_D':
	    {
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + F2B_F2BR_D_TEXT1 + "</li>";
			break;
	    }
		case 'F2B_F2BR_D_M':
	    {
			actions += "<li>" + "<img src='img/tgt_movement-red_small_" + moveicon + ".png' alt='Only if Target has not yet moved' title='Only if Target has not yet moved'>" + F2B_F2BR_D_TEXT2 + "</li>";
			break;
	    }
		case 'FOC2B_FOC2BR_D':
	    {
			actions += "<li>" + FOC2B_FOC2BR_D_TEXT1 + "</li>";
			actions += "<li>" + FOC2B_FOC2BR_D_TEXT2 + "</li>";
			break;
	    }
 	    case 'FOCUS2ROTATE':
   		{
   	        actions += "<li>" + FOCUS2ROTATE_TEXT + "</li>";
   	        break;
   		}
 	    case 'FOCUS2ROTATE_D':
   		{
   	        actions += "<li>" + FOCUS2ROTATE_D_TEXT + "</li>";
   	        break;
   		}
    	case 'FOCUS_OR_CALCULATE':
	    {
		    actions += "<li>" + FOCUS_OR_CALCULATE_TEXT + "</li>";
		    break;
 	    }
    	case 'FOCUS_OR_CALCULATE_SHOT':
	    {
		    actions += "<li>" + FOCUS_OR_CALCULATE_SHOT_TEXT + "</li>";
		    break;
 	    }
    	case 'FOCUS_OR_CALCULATE_M_SHOT':
	    {
		    actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + FOCUS_OR_CALCULATE_SHOT_TEXT + "</li>";
		    break;
 	    }
		case 'B2BR_BR2B_D':
	    {
			actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + B2BR_BR2B_D_TEXT2 + "</li>";
            actions += "<li>" + "<img src=\"img/tgt_movement-green_small_" + moveicon + ".png\" alt='Only if Target has already moved' title='Only if Target has already moved'>" + FOCUS_TEXT2 + "</li>";
			break;
	    }
		case 'B2BR_BR2B_D_M':
	    {
			actions += "<li>" + "<img src='img/tgt_movement-red_small_" + moveicon + ".png' alt='Only if Target has not yet moved' title='Only if Target has not yet moved'>" + B2BR_BR2B_D_TEXT1 + "</li>";
			break;
	    }
		case 'JAM':
	    {
	        actions += "<li>" + JAM_TEXT + "</li>";
	        break;
	    }
		case 'JAM_D':
	    {
	        actions += "<li>" + JAM_D_TEXT + "</li>";
	        break;
	    }
   		case 'LOCK2ROTATE':
	    {
	        actions += "<li>" + LOCK2ROTATE_TEXT + "</li>";
	        break;
	    }
   		case 'LOCK2ROTATE_D':
	    {
	        actions += "<li>" + LOCK2ROTATE_D_TEXT + "</li>";
	        break;
	    }
		case 'RELOAD_D':
		{
			if( reloadTest == 1 )
			{
				actions += "<li>" + RELOAD_D_TEXT2 + "</li>";
				break;
			}
			else
			{
				actions += "<li>" + RELOAD_D_TEXT1 + "</li>";
				break;
			}
		}
		case 'REINFORCE':
		{
			if( reinforceTest == 1 )
			{
				actions += "<li>" + REINFORCE_TEXT1 + "</li>";
				break;
			}
			else if( reinforceTest == 2 )
			{
				actions += "<li>" + REINFORCE_TEXT2 + "</li>";
				break;
			}
			else
			{
				actions += "<li>" + REINFORCE_TEXT0 + "</li>";
				break;
			}
		}
		case 'REINFORCE_D':
		{
			if( reinforceTest == 1 )
			{
				actions += "<li>" + REINFORCE_D_TEXT1 + "</li>";
				break;
			}
			else if( reinforceTest == 2 )
			{
				actions += "<li>" + REINFORCE_D_TEXT2 + "</li>";
				break;
			}
			else
			{
				actions += "<li>" + REINFORCE_D_TEXT0 + "</li>";
				break;
			}
		}
		case 'RELOAD':
	    {
	        actions += "<li>" + RELOAD_TEXT + "</li>";
	        break;
	    }
		case 'RELOAD_D':
	    {
	        actions += "<li>" + RELOAD_D_TEXT + "</li>";
	        break;
	    }
	    case 'RELOAD2CALC_D':
	    {
			actions += "<li>" + RELOAD2CALC_D_TEXT + "</li>";
			break;
	    }
		case 'RELOAD2EVADE_D':
	    {
	        actions += "<li>" + RELOAD2EVADE_D_TEXT1 + "</li>";
	        actions += "<li>" + RELOAD2EVADE_D_TEXT2 + "</li>";
	        break;
	    }
 	    case 'ROTATE_ARC':
 	    {
			if( rotateTest == 1 )
			{
				actions += "<li>" + ROTATE_ARC_TEXT1 + "</li>";
				break;
			}
			else if( rotateTest == 2 )
			{
				actions += "<li>" + ROTATE_ARC_TEXT2 + "</li>";
				break;
			}
			else if( rotateTest == 3 )
			{
				actions += "<li>" + ROTATE_ARC_TEXT3 + "</li>";
				break;
			}
			else if( rotateTest == 4 )
			{
				actions += "<li>" + ROTATE_ARC_TEXT4 + "</li>";
				break;
			}
			else if( rotateTest == 5 )
			{
				actions += "<li>" + "If Turret Upgrade is equipped, " + ROTATE_ARC_TEXT5 + "</li>";
				break;
			}

			else
			{
 	        	break;
			}
 	    }
 	    case 'ROTATE_ARC_D':
 	    {
			if( rotateTest == 1 )
			{
				actions += "<li>" + ROTATE_ARC_D_TEXT1 + "</li>";
				break;
			}
			else if( rotateTest == 2 )
			{
				actions += "<li>" + ROTATE_ARC_D_TEXT2 + "</li>";
				break;
			}
			else if( rotateTest == 3 )
			{
				actions += "<li>" + ROTATE_ARC_D_TEXT3 + "</li>";
				break;
			}
			else
			{
 	        	break;
			}
 	    }
 	    case 'ROTATE2CALC_D':
 	    {
 	        actions += "<li>" + ROTATE_ARC_TEXT2 + "</li>";
 	        actions += "<li>" + ROTATE2CALC_D_TEXT + "</li>";
 	        break;
 	    }
  		case 'SLAM':
  		{
 		    actions += "<li>" + SLAM_TEXT1 + "</li>";
 		    actions += "<li>" + SLAM_TEXT2 + "</li>";
 		    break;
        }
 	    case 'TARGET_LOCK':
 	    {
		    actions += "<li>" + TARGET_LOCK_TEXT + "</li>";
		    break;
 	    }
 	    case 'TARGET_LOCK_D':
 	    {
		    actions += "<li>" + TARGET_LOCK_D_TEXT + "</li>";
		    break;
 	    }
 	    case 'TARGET_LOCK_F':
 	    {
		    actions += "<li>" + TARGET_LOCK_F_TEXT + "</li>";
		    break;
 	    }
	    default:
	    {
			actions += "<li>" + "No Actions Found" + "</li>";
		}
    }
}

function format_attacks( ship )
{
	attacks = "<ol>";
	ship.attacks.forEach(attackText);
	attacks += "<br>" + "In the Aftermath of all attacks, perform Bonus Attack(s).";
	attacks += "</ol>";
	return attacks;
}


function attackText( value, index, array )
{
	switch( value )
	{
    	case 'LOCKED':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked" + "</li>";
        	attacks += "<li>" + "Nearest enemy" + "</li>" + "</ol>" + "<br>";
        	break;
    	}
       	case 'LOCKED_AGRESSOR':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target." + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_cannon_small.png' alt='Cannon' title='Cannon'>, <img src='img/in_arc.png' alt='Front Arc' title='Front Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_cannon_small.png' alt='Cannon' title='Cannon'>, <img src='img/in_arc.png' alt='Front Arc' title='Front Arc'> )" + "</li>" + "</ol>";
           	break;
       	}
 		case 'LOCKED_DEC':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/turret_arc-red_small.png' alt='Turret' title='Turret'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy" + "</li>" + "</ol>" + "<br>";
        	break;
    	}
    	case 'LOCKED_DEF':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>" + "</ol>";
        	break;
    	}

    	case 'LOCKED_ADV':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_SA':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_SF':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'> )" + "</li>" + "</ol>";
        	break;
    	}
       	case 'LOCKED_RB':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target." + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_cannon_small.png' alt='Cannon' title='Cannon'>, <img src='img/turret_arc-red_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_cannon_small.png' alt='Cannon' title='Cannon'>, <img src='img/turret_arc-red_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>";
           	break;
       	}
    	case 'LOCKED_X':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>)" + "</li>";
        	attacks += "<li>" + "Nearest enemy" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_Y':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/turret_arc-red_small.png' alt='Turret' title='Turret'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/turret_arc-red_small.png' alt='Turret' title='Turret'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>" + "</ol>" + "<br>";
        	break;
    	}
    	case 'LOCKED_NR2':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/turret_arc-red_small.png' alt='Turret' title='Turret'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/turret_arc-red_small.png' alt='Turret' title='Turret'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>" + "</ol>" + "<br>";
        	break;
    	}
    	case 'LOCKED_Z95':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>" + "</ol>";
        	break;
    	}
	case 'LOCKED_Z95S':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )*" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>" + "</ol>";
			attacks += "<p>*Always spend the lock to increase chance of dealing damage.</p>";
			attacks += "<p>Clear <img src='img/action_targetlock_small.png' alt='Target-Lock' title='Target Lock'> if unspent.</p>";
        	break;
    	}
    	case 'LOCKED_A':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_A2':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_TIEAG':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_SCURRG':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_B':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_YT2400':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked" + "</li>";
        	attacks += "<li>" + "Nearest enemy at Range 2+" + "</li>";
        	attacks += "<li>" + "Nearest enemy" + "</li>" + "</ol>" + "<br>";
        	break;
    	}
    	case 'LOCKED_GHOST':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>";
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target using <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Nearest Enemy " + "</li>" + "</ol>" + "<br>";

        	break;
    	}
    	case 'LOCKED_M3A':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_HWK290':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> if possible, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'>)" + "</li>";
        	attacks += "<li>" + "Nearest Enemy (priority: <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> if possible, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'>)" + "</li>" + "</ol>" + "<br>";
        	break;
    	}
    	case 'LOCKED_FS':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'> )" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_HMP':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_full_arc_front.png' alt='Full Forward Arc' title='Full Forward Arc'>." + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_full_arc_front.png' alt='Full Forward Arc' title='Full Forward Arc'>." + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_LAATI':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/turret_dual_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/turret_dual_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_YV666':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_full_arc_front.png' alt='Full Forward Arc' title='Full Forward Arc'>." + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_full_arc_front.png' alt='Full Forward Arc' title='Full Forward Arc'>." + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_KWING':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/turret_dual_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/turret_dual_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_CA':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_JUMPMASTER':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_ARC170':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'>)" + "</li>";
        	attacks += "<li>" + "Nearest enemy" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_MG100':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/turret_dual_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy" + "</li>" + "</ol>";
        	break;
    	}
    	case 'LOCKED_GAUNTLET':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'> )" + "</li>" + "</ol>";
        	break;
    	}
       	case 'GUNNER_FS':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest Enemy (priority: <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'> )" + "</li>" + "</ol>";
           	break;
       	}
    	case 'GUNNER_DEC':
    	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if possible due to <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked" + "</li>";
        	attacks += "<li>" + "Nearest enemy" + "</li>" + "</ol>";
        	break;
    	}
       	case 'GUNNER_LAM':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Nearest enemy (priority: <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'> )" + "</li>" + "</ol>";
           	break;
       	}
       	case 'GUNNER_SF':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>";
           	break;
       	}
       	case 'GUNNER_LAATI':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/turret_dual_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/turret_dual_small.png' alt='Turret Arc Arc' title='Turret Arc'> )" + "</li>" + "</ol>";
           	break;
       	}
       	case 'GUNNER_YV666':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_full_arc_front.png' alt='Full Forward Arc' title='Full Forward Arc'>)" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_full_arc_front.png' alt='Full Forward Arc' title='Full Forward Arc'>)" + "</li>" + "</ol>";
           	break;
       	}
       	case 'GUNNER_TRIDENT':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc' )" + "</li>" + "</ol>";
           	break;
       	}
       	case 'GUNNER_KWING':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/turret_dual_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/turret_dual_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>";
           	break;
       	}
       	case 'GUNNER_CA':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>" + "</ol>";
           	break;
       	}
       	case 'GUNNER_JUMPMASTER':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>";
           	break;
       	}
       	case 'GUNNER_TIEAG':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>";
           	break;
       	}
       	case 'GUNNER_SCURRG':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/turret_arc_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>";
           	break;
       	}
       	case 'GUNNER_SE':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Ship that is locked (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/token_torpedo_small.png' alt='Torpedo' title='Torpedo'>, <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc' )" + "</li>" + "</ol>";
           	break;
       	}
       	case 'NEAREST_LAM':
       	{
           	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Nearest Enemy (priority: <img src='img/cannon.png' alt='Cannon' title='Cannon'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/in_rear_arc.png' alt='Rear Arc' title='Rear Arc'> )" + "</li>" + "</ol>" + "<br>";
           	break;
    	}
       	case 'NEAREST_YT1300':
       	{
           	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Nearest Enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/turret_arc-red_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>" + "<br>";
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target using <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<ol>" + "<li>" + "Nearest Enemy (priority: <img src='img/turret_arc-red_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>" + "<br>";
           	break;
    	}
       	case 'NEAREST_FB':
       	{
           	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
			attacks += "<ol>" + "<li>" + "Nearest Enemy (priority: <img src='img/token_missile_small.png' alt='Missile' title='Missile'>, <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'> )" + "</li>" + "</ol>";
           	break;
    	}
       	case 'NEAREST':
       	{
           	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack Target" + "</b>" + "</li>";
			attacks += "<ol>" + "<li>" + "Nearest Enemy" + "</li>" + "</ol>";
           	break;
    	}
       	case 'GUNNER_MG100':
       	{
        	attacks += "<li>" + "<b>" + "<img src='img/attack_target.png' alt='attack target' title='Attack Target'> Attack target if allowed by <img src='img/gunner.png' alt='Gunner' title='Gunner'> " + "</b>" + "</li>";
        	attacks += "<li>" + "Nearest enemy (priority: <img src='img/in_arc.png' alt='Forward Arc' title='Forward Arc'>, <img src='img/turret_dual_small.png' alt='Turret Arc' title='Turret Arc'> )" + "</li>" + "</ol>";
           	break;
       	}
	    default:
	    {
			attacks += "<li>" + "No Actions Found" + "</li>";
		}
	}
}

function format_end( ship )
{
	end = "";
	end += "<p class=\"label\">" + "End Phase" + "</p>";
	end += "<ol>" + "<li>" + "Resolve abilities that occur \'...at the start of the End Phase...\' " + "</li>";
	end += "<li>" + "Resolve abilities that occur \'...during the End Phase...\' " + "</li>";

	if( ship.name == "TIE/ph Phantom" )
	{
		end += "<li>" + "TIE /ph Phantom: OPTIONAL - Spend 1 evade token to gain 1 cloak token" + "</li>";
	}

	end += "<li>" + "Clear all AI ships\' unused Free Target Locks." + "</li>";
	end += "<li>" + "Clear all ships\' unused circular tokens (green and orange)." + "</li>";
	end += "<li>" + "Adjust recurring charges/cards for all ships & upgrades as applicable." + "</li>";
	end += "<li>" + "Check to see if the game has been won. If not, begin the next round" + "</li>" + "</ol>";
	return end;
}

// ****************************************************************************
// Main

function load_index()
{
    set_ship(0);
    display_ship_choice( "Rebel", "set_ship" );
    document.getElementById("SecondEd_map").addEventListener("mousedown", myMousedown);
	document.getElementById("SecondEd_map").addEventListener("mouseup", myMouseup);
	document.getElementById("SecondEd_map").addEventListener("touchstart", myTouchstart);
	document.getElementById("SecondEd_map").addEventListener("touchend", myTouchend);
}


function load_ships()
{
    display_ship(0);
    display_ship_choice( "Rebel", "display_ship" );
}

window.oncontextmenu = function(event)
{
	event.preventDefault();
	event.stopPropagation();
	return false;
}

function blink (direction, ship)
{
    //change map image for selected sector to brighten clicked sector for 200ms
    if( direction == 9 )
    {
		var blinkVar = setTimeout(reroll,100, direction, ship);
    	image_map = 'img/FGA_image_map_blink' + direction + '.png';
    	document.getElementById( "map_img").src = image_map;
	}
	else
	{
		var blinkVar = setTimeout(movement,100, direction, ship);
    	image_map = 'img/FGA_image_map_blink' + direction + '.png';
    	document.getElementById( "map_img").src = image_map;
	}
}


function movement( direction, ship )
{
    //change map image for selected sector
    if( (ship.faction == "Empire") || (ship.faction == "First Order") || (ship.faction == "Seperatist") )
    {
		image_map = 'img/FGA_image_map' + direction + '.png';
	}
	else
	{
		image_map = 'img/FGA_image_map_tie' + direction + '.png';
	}
    document.getElementById( "map_img").src = image_map;

    // direction: nne=0, sne=1, nse=2, sse=3, ssw=4, nsw=5, snw=6,nnw=7, bullseye=8
    // heading: away, closing
    var maneuver;
    var selection = "<p>";
    selection += "at " + DIRECTION[direction] + " o'clock</p>";
    document.getElementById('selection').innerHTML = selection;

    // Select the maneuver randomly from appropriate ship table
    maneuver = pick( SHIP.closing[direction] );
    formatted = format_maneuver( SHIP, maneuver );
    document.getElementById( "closing_num" ).innerHTML = formatted.num;
    document.getElementById( "closing_img" ).innerHTML = formatted.img;

    maneuver = pick( SHIP.away[direction] );
    formatted = format_maneuver( SHIP, maneuver );
    document.getElementById( "away_num" ).innerHTML = formatted.num;
    document.getElementById( "away_img" ).innerHTML = formatted.img;

    maneuver = pick( SHIP.far[direction] );
    formatted = format_maneuver( SHIP, maneuver );
    document.getElementById( "far_num" ).innerHTML = formatted.num;
    document.getElementById( "far_img" ).innerHTML = formatted.img;

    maneuver = pick( SHIP.stressed[direction] );
    formatted = format_maneuver( SHIP, maneuver );
    document.getElementById( "stressed_num" ).innerHTML = formatted.num;
    document.getElementById( "stressed_img" ).innerHTML = formatted.img;
}


function reroll( direction, ship )
{
	image_map = 'img/FGA_image_map.png'
    document.getElementById( "map_img").src = image_map;
	if( ship.name == "TIE/ph Phantom" )
	{
		document.getElementById('system-text').innerHTML = format_system( ship );
	}
	else if ( (cloakersSmall.includes (SHIP.name) ) || (cloakersML.includes (SHIP.name) ) || (cloakersSpecial.includes (SHIP.name) ) )
	{
		document.getElementById('planning-text').innerHTML = format_planning( ship );
	}
	else if( (ship.name == "TIE/sk Striker" ) || (ship.name == "TIE Reaper" ) )
	{
		document.getElementById('preMove-text').innerHTML = format_preMove( ship );
	}
	if( (bombers.includes(SHIP.name)) || (cloakersSmall.includes (SHIP.name)) || (cloakersML.includes (SHIP.name)) || (cloakersSpecial.includes (SHIP.name)) )
	{
		document.getElementById('postsystem-text').innerHTML = format_postsystem( ship, deviceType, deviceName );
	}
}

//These four functions react to DOM events for long-touch and mouse long-press (multiple platforms) to add/remove ships from the Hotlist
function myMousedown()
{
	myLongpress = setTimeout(mydblclick, longPress);
}

function myMouseup()
{
	clearTimeout(myLongpress);
}

function myTouchstart()
{
	myLongtouch = setTimeout(mydblclick, longPress);
}

function myTouchend()
{
	clearTimeout(myLongtouch);
}

//These 2 timing functions differentiate between a user's single and double click on the center ship icon
//This allows for two user functions (rerolls with single click and HOTLIST updates with double-click or long-press) using the same ship_button
function myClick()
{
	clicked++;
	if(clicked >= 2)
	{
		mydblclick();
		clearTimeout(pendingClick);
		clicked = 0;
		return;
	}
	clearTimeout(pendingClick);
	pendingClick = setTimeout(() => {
		blink(DIR_ship, SHIP);
		clicked = 0;
	}, time_dblclick);
}

function mydblclick()
{
	addHotlist( SHIP );
}

//Adds or removes ships to the user's HOTLIST array and stores the updated HOTLIST in sessionStorage
//Shows a 2 second message to the user to confirm that their HOTLIST has been updated
function addHotlist( ship )
{
	if(HOTLIST.indexOf(SHIP.name) == -1)
	{
		HOTLIST.splice(0, 0, SHIP.name);
		sessionStorage.setItem("2EuserHotlist", JSON.stringify(HOTLIST));
		document.getElementById( "shipOnHotlist" ).innerHTML = SHIP.name + " has been added to the Hotlist!";
		setTimeout(function() {document.getElementById( 'shipOnHotlist' ).innerHTML ='';},2000);
		return;
	}
	else if(HOTLIST.includes(SHIP.name))
	{
		HOTLIST.splice(HOTLIST.indexOf(SHIP.name), 1);
		sessionStorage.setItem("2EuserHotlist", JSON.stringify(HOTLIST));
		document.getElementById( "shipOffHotlist" ).innerHTML = SHIP.name + " has been removed from the Hotlist!";
		setTimeout(function() {document.getElementById( 'shipOffHotlist' ).innerHTML ='';},2000);
		display_ship_choice( 'Hotlist', 'set_ship' );
		return;
	}
	else
	{
		return;
	}
}

/* function unblink()
{
    //change map image back to regular image map on mouse release (needed for reroll blink)
    image_map = 'img/FGA_image_map.png';
    document.getElementById( "map_img").src = image_map;
    return;
} */